﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web
{
    public partial class EditInfo : System.Web.UI.Page
    {
        M_Member model = new M_Member();
        B_Member bll = new B_Member();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        DataTable dt = new DataTable();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Request.Cookies["MemberID"] == null)
                {
                    Response.Redirect("Login.aspx", true);
                }
                lblMemberID.Text = Request.Cookies["MemberID"].Value.ToString();
                model.MemberID = Request.Cookies["MemberID"].Value.ToString();
                dt = bll.QueryMemberInfo(model);
                txtName.Text = dt.Rows[0]["MemberName"].ToString();
                txtPhone.Text = dt.Rows[0]["Phone"].ToString();
                txtTel.Text = dt.Rows[0]["Tel"].ToString();
                txtEmail.Text = dt.Rows[0]["Email"].ToString();
                txtQQ.Text = dt.Rows[0]["QQ"].ToString();
                if (dt.Rows[0]["Sex"].ToString() == "男")
                {
                    rbBoy.Checked = true;
                }
                else
                {
                    rbGirl.Checked = true;
                }
            }
        }

        protected void btnChange_Click(object sender, EventArgs e)
        {
            model.MemberID = Request.Cookies["MemberID"].Value.ToString();
            model.MemberName = txtName.Text.Trim();
            model.Phone = txtPhone.Text.Trim();
            model.Tel = txtTel.Text.Trim();
            model.Email = txtEmail.Text.Trim();
            model.QQ = txtQQ.Text.Trim();
            if (rbBoy.Checked == true)
                model.Sex = "男";
            else
                model.Sex = "女";

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Request.Cookies["MemberID"].Value.ToString();
            mLog.UserType = 1;
            if (bll.ChangeInfo(model) > 0)
            {
                mLog.OPInfo = "资料修改成功";
                bLog.AddLog(mLog);
                MyMessageBox.MessageBox("资料修改成功", this.Page, "PersonalInfo.aspx");
            }
            else
            {
                mLog.OPInfo = "资料修改失败";
                bLog.AddLog(mLog);
                MyMessageBox.MessageBox("资料修改失败", this.Page);
            }
                
        }
    }
}
