﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web
{
    public partial class NewsList : System.Web.UI.Page
    {
        B_News bll = new B_News();
        M_News model = new M_News();
        string newsType = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                //if (Request.QueryString["NewsType"] == null)
                //    newsType = "0";
                //else
                //    newsType = Request.QueryString["NewsType"].ToString();
                //switch(newsType)
                //{
                //    case "1":
                //        {
                //            model.TypeID = 1;
                //            anpPager.RecordCount = bll.GetNewsList(model).Rows.Count;
                //            NewsTypeBind(model);
                //        }
                //        break;
                //    case "2":
                //        {
                //            model.TypeID = 2;
                //            anpPager.RecordCount = bll.GetNewsList(model).Rows.Count;
                //            NewsTypeBind(model);
                //        }
                //        break;
                //    case "3":
                //        {   
                //            model.TypeID = 3;
                //            anpPager.RecordCount = bll.GetNewsList(model).Rows.Count;
                //            NewsTypeBind(model);
                //        }
                //        break;
                //    default:
                //        {
                //            lblNewsType.Text = "所有新闻";
                //            anpPager.RecordCount = bll.GetAllNewsList().Rows.Count;
                //            AllNews();
                //        }
                //        break;
                //}


                if (Request.QueryString["NewsType"] == null)
                {
                    lblNewsType.Text = "所有新闻";
                    anpPager.RecordCount = bll.GetAllNewsList().Rows.Count;
                    AllNews();
                }
                else
                {
                    model.TypeID = Convert.ToInt32(Request.QueryString["NewsType"].ToString());
                    if (model.TypeID == 1)
                        lblNewsType.Text = "公司新闻";
                    else if (model.TypeID == 2)
                        lblNewsType.Text = "公司通知";
                    else
                        lblNewsType.Text = "行业新闻";
                    anpPager.RecordCount = bll.GetNewsList(model).Rows.Count;
                    NewsTypeBind(model);
                }
            }
        }

        protected void anpPager_PageChanged(object sender, EventArgs e)
        {
            if (Request.QueryString["NewsType"] == null)
                AllNews();
            else
            {
                model.TypeID = Convert.ToInt32(Request.QueryString["NewsType"].ToString());
                NewsTypeBind(model);
            }
        }

        private void NewsTypeBind(M_News model)
        {
            PagedDataSource pdsList = new PagedDataSource();
            //对PagedDataSource 对象的相关属性赋值        
            pdsList.DataSource = bll.GetNewsList(model).DefaultView;
            pdsList.AllowPaging = true;
            pdsList.PageSize = anpPager.PageSize;
            //pdsList.AllowCustomPaging = true;
            pdsList.CurrentPageIndex = anpPager.CurrentPageIndex - 1;
            rptNewsList.DataSource = pdsList;
            rptNewsList.DataBind();
        }

        private void AllNews()
        {
            PagedDataSource pdsList = new PagedDataSource();
            //对PagedDataSource 对象的相关属性赋值        
            pdsList.DataSource = bll.GetAllNewsList().DefaultView;
            pdsList.AllowPaging = true;
            pdsList.PageSize = anpPager.PageSize;
            //pdsList.AllowCustomPaging = true;
            pdsList.CurrentPageIndex = anpPager.CurrentPageIndex - 1;
            rptNewsList.DataSource = pdsList;
            rptNewsList.DataBind();
        }

        protected void ibCompany_Click(object sender, ImageClickEventArgs e)
        {
            Response.Redirect("NewsList.aspx?NewsType=1");
        }

        protected void ibMessage_Click(object sender, ImageClickEventArgs e)
        {
            Response.Redirect("NewsList.aspx?NewsType=2");
        }

        protected void ibProfession_Click(object sender, ImageClickEventArgs e)
        {
            Response.Redirect("NewsList.aspx?NewsType=3");
        }

        protected void ibAllNews_Click(object sender, ImageClickEventArgs e)
        {
            Response.Redirect("NewsList.aspx");
        }
    }
}
