﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web
{
    public partial class Register : System.Web.UI.Page
    {
        M_Member model = new M_Member();
        B_Member bll = new B_Member();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {

        }
        /// <summary>
        /// 判断验证码是否正确
        /// </summary>
        /// <param name="source"></param>
        /// <param name="args"></param>
        protected void CustomValidator2_ServerValidate(object source, ServerValidateEventArgs args)
        {
            if (txtRandomCode.Text.Trim().ToUpper() == Session["CheckCode"].ToString())
            {
                args.IsValid = true;
            }
            else
            {
                args.IsValid = false;
            }
        }
        /// <summary>
        /// 判断账号是否已被注册
        /// </summary>
        /// <param name="source"></param>
        /// <param name="args"></param>
        protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
        {
            model.MemberID = txtMemberID.Text.Trim();
            bool flag = bll.IsExistMember(model);
            if (flag == true)
            {
                //验证没通过，账号已被注册
                args.IsValid = false;
            }
            else
            {
                args.IsValid = true;
            }
        }

        protected void btnRegister_Click(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                model.MemberID = txtMemberID.Text.Trim();
                model.Password = txtPwd.Text.Trim();
                model.MemberName = txtName.Text.Trim();
                model.Phone = txtPhone.Text.Trim();
                model.Tel = txtTel.Text.Trim();
                model.Email = txtEmail.Text.Trim();
                model.QQ = txtQQ.Text.Trim();
                model.Question = txtQuestion.Text.Trim();
                model.Answer = txtAnswer.Text.Trim();
                if (rbBoy.Checked == true)
                    model.Sex = "男";
                else
                    model.Sex = "女";

                mLog.UserIP = ClientInfo.GetUserIP();
                mLog.URL = Request.Url.AbsoluteUri.ToString();
                mLog.Account = txtMemberID.Text.Trim();
                mLog.UserType = 1;
                
                if (bll.AddMember(model) > 0)
                {
                    mLog.OPInfo = "注册账号成功";
                    bLog.AddLog(mLog);
                    //Response.Write("<script language='javascript'>alert('恭喜您,注册成功,系统将返回登录页面');location.href='Login.aspx';</script>");
                    MyMessageBox.MessageBox("恭喜您,注册成功,系统将返回登录页面", this.Page, "Login.aspx");
                }
                else
                {
                    mLog.OPInfo = "注册账号失败";
                    bLog.AddLog(mLog);
                    //Response.Write("<script language='javascript'>alert('对不起，注册失败！');location.href='Register.aspx'</script>");
                    MyMessageBox.MessageBox("对不起，注册失败！", this.Page);
                }
            }
        }
    }
}
