﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.Common;
using LZBS.BLL;
using LZBS.Model;

namespace LZBS.Web
{
    public partial class Retrieve : System.Web.UI.Page
    {
        B_Member bll = new B_Member();
        M_Member model = new M_Member();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.QueryString["MemberID"] == null)
            {
                MyMessageBox.MessageBox("请先输入账号再找回密码", this.Page, "Login.aspx");
            }
            else
            {
                model.MemberID = Request.QueryString["MemberID"].ToString();
                if (bll.IsExistMember(model) == true)
                {
                    DataRow dr = bll.QueryMemberInfo(model).Rows[0];
                    lblMemberID.Text = dr["MemberID"].ToString();
                    lblQuestion.Text = dr["Question"].ToString();
                }
                else
                {
                    MyMessageBox.MessageBox("你输入的账号错误，请重新输入", this.Page, "Login.aspx");
                }
            }
        }

        protected void btnConfirm_Click(object sender, EventArgs e)
        {
            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Request.QueryString["MemberID"].ToString();
            mLog.UserType = 1;

            model.MemberID = Request.QueryString["MemberID"].ToString();
            DataRow dr = bll.QueryMemberInfo(model).Rows[0];
            if (txtAnswer.Text.Trim() == dr["Answer"].ToString())
            {
                mLog.OPInfo = "通过回答问题找回密码，答案正确";
                Response.Cookies["Answer"].Value = Request.QueryString["MemberID"].ToString();
                Response.Redirect("Retrieve.aspx", true);
            }
            else
            {
                mLog.OPInfo = "通过回答问题找回密码，答案错误";
                MyMessageBox.MessageBox("答案错误，请重试", this.Page);
            }
            bLog.AddLog(mLog);
        }
    }
}
