﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem
{
    public partial class AddTrainsForm : Form
    {
        public AddTrainsForm()
        {
            InitializeComponent();
        }
       
        DataDataContext ddt = new DataDataContext();
        private void AddTrainsForm_Load(object sender, EventArgs e)
        {
            //加载时绑定数据源
            combo_name.DataSource = ddt.T_StaffRecords;
            combo_name.DisplayMember = "Staff_name";
            combo_name.ValueMember = "Staff_id";
            var result = ddt.T_Trainings.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (train1, staff) => new { train1.Training_ID, staff.Staff_Name, train1.Training_Content, train1.Training_Grade, train1.Training_Address, train1.Training_StartTime, train1.Training_EndTime });
            dataGridView1.DataSource = result;
        }
        T_Trainings train = new T_Trainings();
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            //异常处理
            try
            {
                train.Training_Address = txt_address.Text;
                train.Training_Content = txt_content.Text;
                train.Training_Grade = Convert.ToInt32(txt_grade.Text.ToString());
                train.Training_StartTime = dtpicker_time1.Value;
                train.Training_EndTime = dtpicker_time2.Value;
                train.Staff_ID = Convert.ToInt32(combo_name.SelectedValue);

            }
            catch
            {
                MessageBox.Show("字符串转化不正确！");
            }
            ddt.T_Trainings.InsertOnSubmit(train);//添加数据
            ddt.SubmitChanges();
            //绑定数据源
            var result = ddt.T_Trainings.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (train1, staff) => new { train1.Training_ID, staff.Staff_Name, train1.Training_Content, train1.Training_Grade, train1.Training_Address, train1.Training_StartTime, train1.Training_EndTime });
            dataGridView1.DataSource = result;
        }

       
    }
}
