﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;

namespace HRManagerSystem.Bll
{
    class Department
    {
        /// <summary>
        /// 获取部门表中的全部信息
        /// </summary>
        /// <returns></returns>
        public DataTable DepartName()
        {
            //新建一个表
            DataTable dt = new DataTable();
            dt.Columns.Add("部门编号");
            dt.Columns.Add("部门名称");
            dt.Columns.Add("父部门名称");
            DataDataContext ddt = new DataDataContext();

            //查找部门表中的全部信息
            var result = ddt.T_Department.Select(dd => dd);
            foreach (var val in result)
            {
                //把部门表中的信息全部赋值给DataTable
                DataRow dr = dt.NewRow();
                dr[0] = val.Depart_ID;
                dr[1] = val.Depart_Name;
                //如果有父部门
                if (val.Parent_ID != 0)
                {
                    dr[2] = result.Single(w => w.Depart_ID == val.Parent_ID).Depart_Name;
                }
                else
                {
                    dr[2] = "无";
                }
                dt.Rows.Add(dr);
            }
            return dt;
            
        }
        /// <summary>
        /// 根据部门名称查询部门信息
        /// </summary>
        /// <param name="departname"></param>
        /// <returns></returns>
        public DataTable SearchDepart(string departname)
        {
            //新建一个表
            DataTable dt = new DataTable();
            dt.Columns.Add("部门编号");
            dt.Columns.Add("部门名称");
            dt.Columns.Add("父部门名称");
            DataDataContext ddt = new DataDataContext();

            //根据名称查找部门表中的全部信息
            var result = ddt.T_Department.Where(name => name.Depart_Name.ToString() == departname);
            foreach (var val in result)
            {
                //把部门表中的信息全部赋值给DataTable
                DataRow dr = dt.NewRow();
                dr[0] = val.Depart_ID;
                dr[1] = val.Depart_Name;
                //如果有父部门
                if (val.Parent_ID != 0)
                {
                    dr[2] = ddt.T_Department.Single(w => w.Depart_ID == val.Parent_ID).Depart_Name;
                }
                else
                {
                    dr[2] = "无";
                }
                dt.Rows.Add(dr);
            }
            return dt;

        }
    }
}
