﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Transactions;


namespace HRManagerSystem
{
    public partial class DD_AddStaffdd : Form
    {
        public DD_AddStaffdd()
        {
            InitializeComponent();
        }
        public DD_AddStaffdd(DataTable dt)
        {
            InitializeComponent();

        }
        DataDataContext ddc = new DataDataContext();
        
        private void DD_AddStaffdd_Load(object sender, EventArgs e)
        { 
            DD_AddDGV.Visible = false;
        }
        private void DD_AddStaffidCB_Click(object sender, EventArgs e)
        {
            DD_AddDGV.Visible = true;
            DD_AddDGV.DataSource = ddc.V_DDStaff;
        }
        #region 获得员工原来信息
        private void DD_AddDGV_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex > -1)
            {
                string di = Convert.ToString(DD_AddDGV.Rows[e.RowIndex].Cells[0].Value);
                string name = Convert.ToString(DD_AddDGV.Rows[e.RowIndex].Cells[1].Value);
                string depart = Convert.ToString(DD_AddDGV.Rows[e.RowIndex].Cells[2].Value);
                string job = Convert.ToString(DD_AddDGV.Rows[e.RowIndex].Cells[3].Value);
                DD_AddStaffidCB.Text = di;//员编号工
                DD_AddStaffnameTB.Text = name;//员工姓名
                DD_AddOldDepartTB.Text = depart;//员工部门
                DD_AddOldJobTB.Text = job;//员工职务
            }
            DD_AddDGV.Visible = false;
        } 
        #endregion
        private void DD_AddNewDepartCB_Click(object sender, EventArgs e)
        {
            DD_AddNewDepartCB.DataSource = ddc.T_Department.Select(var => var.Depart_Name);
        }
        private void DD_AddNewJobCB_Click(object sender, EventArgs e)
        {
            DD_AddNewJobCB.DataSource = ddc.T_Jobs.Select(var => var.Job_Name);
        }
        TransactionScope ts = new TransactionScope();
        #region 用事务添加员工信息
        private void DD_AddSaveTSB_Click(object sender, EventArgs e)
        {
            T_DiaoDu dd = new T_DiaoDu();           
            if (DD_AddNewDepartCB.Text != "" && DD_AddNewJobCB.Text != "")
            {
                //判断是否符合调度条件信息
                if (DD_AddNewDepartCB.Text == DD_AddOldDepartTB.Text && DD_AddOldJobTB.Text == DD_AddNewJobCB.Text)
                {
                    MessageBox.Show("部门和职务信息不变，不能调度！");
                }
                else
                {                    
                    #region 往调度表中添加信息

                    var Newva = ddc.T_Department.Single(str => str.Depart_Name == DD_AddNewDepartCB.Text);
                    var Oldva = ddc.T_Department.Single(str => str.Depart_Name == DD_AddOldDepartTB.Text);
                    var Newsa = ddc.T_Jobs.Single(str => str.Job_Name == DD_AddNewJobCB.Text);
                    var Oldsa = ddc.T_Jobs.Single(str => str.Job_Name == DD_AddOldJobTB.Text);
                    dd.New_DepartID = Newva.Depart_ID;//添加新部门
                    dd.New_JobID = Newsa.Job_ID;//添加老职务
                    dd.Old_DepartID = Oldva.Depart_ID;//添加老部门
                    dd.Old_JobID = Oldsa.Job_ID;//添加老部门
                    dd.DiaoDu_Time = DateTime.Now;
                    dd.Staff_ID = Convert.ToInt32(DD_AddStaffidCB.Text);//员工编号
                    ddc.T_DiaoDu.InsertOnSubmit(dd);
                    ddc.SubmitChanges();

                    #endregion

                    #region 向员工表中添加数据
                    var Newdid = ddc.T_Department.Single(str => str.Depart_Name == DD_AddNewDepartCB.Text);
                    var Newjid = ddc.T_Jobs.Single(str => str.Job_Name == DD_AddNewJobCB.Text);
                    var av = ddc.T_StaffRecords.Single(str => str.Staff_ID == Convert.ToInt32(DD_AddStaffidCB.Text));
                    av.Staff_DepartID = Newdid.Depart_ID;//部门
                    av.Staff_JobID = Newjid.Job_ID;//职务

                    ddc.SubmitChanges();
                    ts.Complete();
                    ts.Dispose();
                    #endregion
                    MessageBox.Show("添加成功！");

                    //添加成功并修改完成了员工信息，清空
                    DD_AddStaffidCB.Text = "";
                    DD_AddNewDepartCB.SelectedIndex = 0;
                    DD_AddOldDepartTB.Text = "";
                    DD_AddNewJobCB.SelectedIndex = 0;
                    DD_AddOldJobTB.Text = "";

                }
            }
            else
            {
                MessageBox.Show("请选择新部门和职务！");
            }
        }
       
        #endregion
        /// <summary>
        /// 退出
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DD_AddQuitTSB_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        /// <summary>
        /// 重新添加信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void DD_AddTSB_Click(object sender, EventArgs e)
        {
            DD_AddStaffidCB.Text = "";
            DD_AddStaffnameTB.Text = "";
            DD_AddOldDepartTB.Text = "";
            DD_AddOldJobTB.Text = "";
            DD_AddNewDepartCB.Text = "";
            DD_AddNewJobCB.Text = "";
        }
    }
}
