﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using HRManagerSystem.Bll;
namespace HRManagerSystem
{
    public partial class FuLiForm : Form
    {
        public FuLiForm()
        {
            InitializeComponent();
        }
        DataDataContext ddt = new DataDataContext();
        public void FuLiForm_Load(object sender, EventArgs e)
        {
            //绑定默认日期
            dtpicker_time1.Value = Convert.ToDateTime("2010-7-8");
            dtpicker_time2.Value = DateTime.Now;
            //加载数据源
            var result = ddt.T_FuLi.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (id1, staid1) => new { id1.FL_ID, id1.FL_Cause, id1.FL_Time, id1.FL_Money, staid1.Staff_Name });
            dataGridView1.DataSource = result;
            //显示状态栏中记录总数
            toolStripStatusLabel2.Text = ddt.T_FuLi.Count().ToString();
        }

        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        T_FuLi fuliinfo = new T_FuLi();
        T_StaffRecords staff = new T_StaffRecords();
        bool mark = false;
        int fuliid = 0;
        private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex > -1)
            {
                fuliinfo = ddt.T_FuLi.Single(id => id.FL_ID == Convert.ToInt32(dataGridView1.Rows[e.RowIndex].Cells[0].Value));
                //fuli.FL_Cause = dataGridView1.Rows[e.RowIndex].Cells[1].Value.ToString();
                //fuli.FL_Time = Convert.ToDateTime(dataGridView1.Rows[e.RowIndex].Cells[2].Value.ToString());
                //fuli.FL_Money = Convert.ToDecimal(dataGridView1.Rows[e.RowIndex].Cells[3].Value.ToString());
                staff.Staff_Name = (dataGridView1.Rows[e.RowIndex].Cells[4].Value.ToString().ToString());
                fuliid = fuliinfo.FL_ID;

            }
            mark = true;
        }

        /// <summary>
        /// 删除一条记录
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            if (mark)
            {
                var fuliinfo = ddt.T_FuLi.Single(fuli => fuli.FL_ID == fuliid);
                if (DialogResult.OK == MessageBox.Show("你确定要删除么？", "提示", MessageBoxButtons.YesNo))
                ddt.T_FuLi.DeleteOnSubmit(fuliinfo);//单个删除
                ddt.SubmitChanges();
                //加载数据源
               var result = ddt.T_FuLi.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (id1, staid1) => new { id1.FL_ID, id1.FL_Cause, id1.FL_Time, id1.FL_Money, staid1.Staff_Name }).AsQueryable();
                dataGridView1.DataSource = result;
                //显示状态栏中记录总数
                toolStripStatusLabel2.Text = ddt.T_FuLi.Count().ToString();
            }
            else
            {
                MessageBox.Show("请先选择一行数据再进行删除操作！", "提示", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }

        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            //show出添加页面窗体
            AddFuLiForm addfl = new AddFuLiForm();
            addfl.ShowDialog();
            //加载数据源
            var result = ddt.T_FuLi.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (id1, staid1) => new { id1.FL_ID, id1.FL_Cause, id1.FL_Time, id1.FL_Money, staid1.Staff_Name }).AsQueryable();
            dataGridView1.DataSource = result;
            
           
        }
        /// <summary>
        /// 修改福利信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            if (mark)
            {
                UpdateFuLiForm upfuli = new UpdateFuLiForm(fuliinfo,staff);
                upfuli.ShowDialog();
                ddt.SubmitChanges();
                //加载数据源
                var result = ddt.T_FuLi.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (id1, staid1) => new { id1.FL_ID, id1.FL_Cause, id1.FL_Time, id1.FL_Money, staid1.Staff_Name }).AsQueryable();
                dataGridView1.DataSource = result;
            }
            else
            {
                MessageBox.Show("在修改之前请选择一列数据！");
            }



        }
       
        /// <summary>
        /// 查找操作
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            FuLiSearchForm search = new FuLiSearchForm();
            search.ShowDialog();
        }
        //刷新
        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            var result = ddt.T_FuLi.Join(ddt.T_StaffRecords, id => id.Staff_ID, staid => staid.Staff_ID, (id1, staid1) => new { id1.FL_ID, id1.FL_Cause, id1.FL_Time, id1.FL_Money, staid1.Staff_Name }).AsQueryable();
            dataGridView1.DataSource = result;
        }

       
       

       


    }
}
