﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Configuration;
using HRManagerSystem.StaffManage;
using HRManagerSystem.Bll;
using System.IO;

namespace HRManagerSystem
{
    public partial class StaffForm : Form
    {
        public StaffForm()
        {
            InitializeComponent();
        }
        DataDataContext ddc = new DataDataContext();
        SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["HRManagerSystem.Properties.Settings.HR_DBConnectionString"].ConnectionString);
        private void StaffForm_Load(object sender, EventArgs e)
        {
            // TODO: 这行代码将数据加载到表“hR_DBDataSet.V_StaffDetail”中。您可以根据需要移动或移除它。
            //this.v_StaffDetailTableAdapter.Fill(this.hR_DBDataSet.V_StaffDetail);

            LoadAll();
            LoadTree(treeView1.Nodes[0]);//加载部门树 以根节点调用（遍历它的所有子部门）
            bt_datain.Enabled = false;


            //为绑定的combox 的集合追加一个元素
            List<string> slist = new List<string>();
            slist.Add("全体员工");
            foreach (var c in ddc.T_Type.Select(te => te.Type_Name))
            {
                slist.Add(c);
            }
            cob_selectBytype.DataSource = slist;
        }

        /// <summary>
        /// ADO.NET 实现 dataGridView1和视图绑定
        /// </summary>
        void LoadAll()
        {
            string sqlstr = "select * from V_StaffDetail";
            // string sqlstr = "SELECT dbo.T_StaffRecords.Staff_ID, dbo.T_StaffRecords.Staff_Name,dbo.T_StaffRecords.Staff_Sex, dbo.T_Nation.Nation_Name, dbo.T_ZhiCheng.ZhiCheng_Name, dbo.T_Jobs.Job_Name, dbo.T_Department.Depart_Name, dbo.T_StaffRecords.Staff_Education,dbo.T_Type.Type_Name, dbo.T_StaffRecords.Staff_IDNumber, dbo.T_StaffRecords.Staff_Mobile, dbo.T_StaffRecords.Staff_Phone,dbo.T_StaffRecords.Staff_Email, dbo.T_StaffRecords.Staff_Address  FROM dbo.T_StaffRecords INNER JOIN dbo.T_Jobs ON dbo.T_StaffRecords.Staff_JobID = dbo.T_Jobs.Job_ID INNER JOIN dbo.T_Nation ON dbo.T_StaffRecords.Staff_NationID = dbo.T_Nation.Nation_ID INNER JOIN dbo.T_Type ON dbo.T_StaffRecords.Staff_TypeID = dbo.T_Type.Type_ID INNER JOIN dbo.T_ZhiCheng ON dbo.T_StaffRecords.Staff_ZhiChengID = dbo.T_ZhiCheng.ZhiCheng_ID INNER JOIN dbo.T_Department ON dbo.T_StaffRecords.Staff_DepartID = dbo.T_Department.Depart_ID";
            SqlDataAdapter da = new SqlDataAdapter(sqlstr, con);
            DataSet ds = new DataSet();
            da.Fill(ds);           
            ds.Tables[0].Columns.Add("性别", typeof(string), "IIF([Staff_Sex]=true,'男','女')");//给视图添加一列
            dataGridView1.DataSource = ds.Tables[0];
            lb_count.Text = "共" + ds.Tables[0].Rows.Count.ToString() + "人";
        }
        /// <summary>
        /// 将treeview 绑定到部门---递归实现
        /// </summary>
        /// <param name="tn"></param>
        void LoadTree(TreeNode tn)
        {
            foreach (T_Department depar in ddc.T_Department.Where(dep => dep.Parent_ID == Convert.ToInt32(tn.Name)))
            {
                LoadTree(tn.Nodes.Add(depar.Depart_ID.ToString(), depar.Depart_Name));
            }
        }
        /// <summary>
        /// combox 选项变化时触发
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        
        private void cob_selectBytype_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cob_selectBytype.Text == "全体员工")
            {
               LoadAll();
            }
            else
            {
                dataGridView1.DataSource = ddc.V_StaffDetail.Where(se2 => se2.Type_Name == cob_selectBytype.SelectedItem.ToString());
                lb_count.Text = "共" + ddc.V_StaffDetail.Where(se2 => se2.Type_Name == cob_selectBytype.SelectedItem.ToString()).Count() + "人";
            }
        }  
        /// <summary>
        /// 【添加】
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            AddStaffForm adds = new AddStaffForm();
            adds.ShowDialog();
        }
        /// <summary>
        /// 【刷新】
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        
        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            LoadAll();
        }
        DataDataContext dde = new DataDataContext();
        /// <summary>
        /// 选中一条记录，进行修改，并将对象传到 修改页面
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            if (mark3)
            {
                mark3 = !mark3;
                UpdateStaffForm uf = new UpdateStaffForm(newstaff);
                uf.ShowDialog();
                ddc.SubmitChanges();
                LoadAll();//提交后重新绑定
            }
            else
            {
                MessageBox.Show("请选中一条记录再进行操作！");
            }
        }
        T_StaffRecords newstaff = new T_StaffRecords();
        /// <summary>
        /// 选中dataGridView的某行的某个单元格
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        bool mark3 = false;
        private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            string photoPath="";
            if (e.RowIndex > -1)
            {
                mark3 = true;
                newstaff.Staff_ID = Convert.ToInt32(dataGridView1.Rows[e.RowIndex].Cells[0].Value);              
                var dd= ddc.T_StaffRecords.Single (t=>t.Staff_ID ==newstaff.Staff_ID);
                photoPath= dd.Photo_Path;//获取选中员工的照片路径
                PhotoOpt(photoPath );
            }
        }
        /// <summary>
        /// 照片的操作
        /// </summary>
        /// <param name="path"></param>
            void PhotoOpt(string path)
            {
                //Application.StartupPath获取启动了应用程序的可执行文件的路径（不包括可执行文件的名称）
                if(File.Exists (Application.StartupPath + "\\images\\" + path))
                {
                    if ((Application.StartupPath + "\\images\\" +path)!="")
                    {
                        pictureBox1.Image = Image.FromFile(Application.StartupPath + "\\images\\" + path);//若存在，加载显示
                    }             
                }
                else
                {
                    pictureBox1.Image = Image.FromFile(Application.StartupPath + "\\images\\0.bmp");
                }
            }    
      /// <summary>
      /// 删除 操作的提醒
      /// </summary>
      /// <param name="sender"></param>
      /// <param name="e"></param>
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            try
            {
                if (mark3)
                {
                    mark3 = !mark3;
                    if (DialogResult.OK == MessageBox.Show("确定要删除吗！", "提示", MessageBoxButtons.OKCancel, MessageBoxIcon.Information))
                    {
                        var ddd = ddc.T_StaffRecords.Single(b => b.Staff_ID == newstaff.Staff_ID);//在数据库中检索到 
                        ddc.T_StaffRecords.DeleteOnSubmit(ddd);//提交删除
                        ddc.SubmitChanges();
                        LoadAll();//重新加载
                    }
                }
                else
                {
                    MessageBox.Show("请选择一条记录再进行操作！");
                }
            }
            catch
            {
                MessageBox.Show("删除前请选择一条记录！");
            }
        }
        /// <summary>
        /// 【查找】按钮的操作
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            if (txt_select.Text != "")
            {
                if (rabt_Id.Checked)
                {
                    dataGridView1.DataSource = ddc.V_StaffDetail.Where(a => a.Staff_ID == Convert.ToInt32(txt_select.Text));
                    lb_count.Text = "共" + ddc.V_StaffDetail.Where(a => a.Staff_ID == Convert.ToInt32(txt_select.Text)).Count().ToString() + "人";
                    if (ddc.V_StaffDetail.Where(a => a.Staff_ID == Convert.ToInt32(txt_select.Text)).Count() == 0)
                    {
                        MessageBox.Show("没有检索到相关信息！");
                    }
                }
                else
                {
                    dataGridView1.DataSource = ddc.V_StaffDetail.Where(se1 => se1.Staff_Name == txt_select.Text);
                    lb_count.Text = "共" + ddc.V_StaffDetail.Where(se1 => se1.Staff_Name == txt_select.Text).Count().ToString() + "人";
                    if (ddc.V_StaffDetail.Where(se1 => se1.Staff_Name == txt_select.Text).Count() == 0)
                    {
                        MessageBox.Show("没有检索到相关信息！");
                    }
                }
            }
        }
        /// <summary>
        /// radiobutton 的操作--根据选中和填入的相关信息检索 员工信息【检索】
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            if (txt_select.Text != "")
            {
                if (rabt_Id.Checked)
                {
                    dataGridView1.DataSource = ddc.V_StaffDetail.Where(a => a.Staff_ID == Convert.ToInt32(txt_select.Text));//根据员工编号
                    lb_count.Text = "共" + ddc.V_StaffDetail.Where(a => a.Staff_ID == Convert.ToInt32(txt_select.Text)).Count().ToString() + "人";
                    if (ddc.V_StaffDetail.Where(a => a.Staff_ID == Convert.ToInt32(txt_select.Text)).Count() == 0)
                    {
                        MessageBox.Show("没有检索到相关信息！");
                    }
                }
                else
                {
                    dataGridView1.DataSource = ddc.V_StaffDetail.Where(se1 => se1.Staff_Name == txt_select.Text);//根据员工姓名
                    lb_count.Text = "共" + ddc.V_StaffDetail.Where(se1 => se1.Staff_Name == txt_select.Text).Count().ToString() + "人";
                    if (ddc.V_StaffDetail.Where(se1 => se1.Staff_Name == txt_select.Text).Count() == 0)
                    {
                        MessageBox.Show("没有检索到相关信息！");
                    }
                }
            }
        }
        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        /// <summary>
        /// 根据部门名称检索员工详细信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {
           dataGridView1.DataSource =  ddc.V_StaffDetail .Where (d=>d.Depart_Name.ToString() ==treeView1.SelectedNode.Text  );
           lb_count.Text ="共"+ ddc.V_StaffDetail.Where(d => d.Depart_Name.ToString() == treeView1.SelectedNode.Text).Count().ToString ()+"人";
           if (ddc.V_StaffDetail.Where(d => d.Depart_Name.ToString() == treeView1.SelectedNode.Text).Count() == 0)
           {
               MessageBox.Show("该部门还没有员工!");
           }          
        
        }
        /// <summary>
        /// 数据导出操作
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void bt_dataout_Click(object sender, EventArgs e)
        {
            try
            {
                Staff sta = new Staff();
                sta.ExportDataGridview(dataGridView1, true);
            }
            catch
            { 
            
            }
        }

       

       
    }
}
