﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace HRManagerSystem
{
    public partial class UpdateStaffForm : Form
    {
        public UpdateStaffForm()
        {
            InitializeComponent();
        }
        DataDataContext ddc = new DataDataContext();
        T_StaffRecords s = new T_StaffRecords();
        /// <summary>
        /// 重载构造函数（将选中的另一个页面中的记录的传入此页面）
        /// </summary>
        /// <param name="ss"></param>
        public UpdateStaffForm(T_StaffRecords ss)
        {
            InitializeComponent();
            this.s = ss;
            staffid = s.Staff_ID;
        } 
        /// <summary>
        /// 加载各个Combox 信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>      
        private void UpdateStaffForm_Load(object sender, EventArgs e)
        {            
            cob_job.DataSource = ddc.T_Jobs.Select(se => new { se.Job_Name, se.Job_ID });
            cob_job.DisplayMember = "Job_Name";
            cob_job.ValueMember = "Job_ID";

            cob_nat.DataSource = ddc.T_Nation.Select(sv => new { sv.Nation_Name, sv.Nation_ID });
            cob_nat.DisplayMember = "Nation_Name";
            cob_nat.ValueMember = "Nation_ID";
            cob_ty.DataSource = ddc.T_Type.Select(s1 => new { s1.Type_Name, s1.Type_ID });
            cob_ty.DisplayMember = "Type_Name";
            cob_ty.ValueMember = "Type_ID";
            cob_dep.DataSource = ddc.T_Department.Select(s2 => new { s2.Depart_Name, s2.Depart_ID });
            cob_dep.DisplayMember = "Depart_Name";
            cob_dep.ValueMember = "Depart_ID";
            cob_zc.DataSource = ddc.T_ZhiCheng.Select(s3 => new { s3.ZhiCheng_Name, s3.ZhiCheng_ID });
            cob_zc.DisplayMember = "ZhiCheng_Name";
            cob_zc.ValueMember = "ZhiCheng_ID";
            txt_id.Enabled = false;

            show(s.Staff_ID);
        }
       /// <summary>
       /// 根据员工编号，显示员工详细信息
       /// </summary>
       /// <param name="i"></param>
        void show(int i)
        {
            var dc = ddc.V_StaffDetail.Single(cc => cc.Staff_ID == i);
            txt_id.Text = dc.Staff_ID.ToString();
            txt_id.ReadOnly = true;
            txt_name.Text = dc.Staff_Name;
            txt_idnum.Text = dc.Staff_IDNumber;
            txt_mob.Text = dc.Staff_Mobile;
            txt_ph.Text = dc.Staff_Phone;
            txt_em.Text = dc.Staff_Email;
            txt_edu.Text = dc.Staff_Education;
            txt_addr.Text = dc.Staff_Address;
            cob_dep.Text = dc.Depart_Name;
            cob_job.Text = dc.Job_Name;
            cob_nat.Text = dc.Nation_Name;
            cob_ty.Text = dc.Type_Name;
            cob_zc.Text = dc.ZhiCheng_Name;
            var cf = ddc.T_StaffRecords.Single(ff => ff.Staff_ID == i);
            if (File.Exists(Application.StartupPath + "\\images\\" + cf.Photo_Path))
            {
                pictureBox1.Image = Image.FromFile(Application.StartupPath + "\\images\\" + cf.Photo_Path);
            }
            else
            {
                pictureBox1.Image = Image.FromFile(Application.StartupPath + "\\images\\0.bmp" );
            }
            cob_sex.Text = dc.Staff_Sex == true ? "男" : "女";
        }
        /// <summary>
        /// 修改后进行保存
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            var sr = ddc.T_StaffRecords.Single(a => a.Staff_ID == s.Staff_ID);//根据选中的记录的员工编号，获取该记录，进行修改
            sr.Staff_Address = txt_addr.Text;
            sr.Staff_DepartID = Convert.ToInt32(cob_dep.SelectedValue.ToString());//Combox的选中的内容记录到数据库中
            if (txt_edu.Text!="")
            {
                sr.Staff_Education = txt_edu.Text;
            }
            else
            {
                MessageBox.Show("为必填项！");
            }
            if (txt_em.Text!="")
            { 
                sr.Staff_Email = txt_em.Text;
            }
            else
            {
                MessageBox.Show("为必填项！");
            }
            if (txt_idnum.Text!="")
            { 
             sr.Staff_IDNumber = txt_idnum.Text;
            }
            else
            {
                MessageBox.Show("为必填项！");
            }
            
            sr.Staff_JobID = Convert.ToInt32(cob_job.SelectedValue.ToString());
            if (txt_mob.Text!="")
            {
                sr.Staff_Mobile = txt_mob.Text;
            }
            else
            {
                MessageBox.Show("为必填项！");
            }

            if (txt_name.Text != "")
            {
                sr.Staff_Name = txt_name.Text;
            }
            else
            {
                MessageBox.Show("为必填项！");
            }
            sr.Staff_NationID = Convert.ToInt32(cob_nat.SelectedValue.ToString());
            sr.Staff_Phone = txt_ph.Text;
           //男女的判断
            if (cob_sex.Text != "")
            {
                sr.Staff_Sex = cob_sex.Text == "男" ? true : false;
            }
            else 
            {
                MessageBox.Show("请选择正确的选项！");
            }
            sr.Staff_TypeID = Convert.ToInt32(cob_ty.SelectedValue.ToString());
            sr.Staff_ZhiChengID = Convert.ToInt32(cob_zc.SelectedValue.ToString());
            //照片的处理
            try
            {
                if (File.Exists(str1))
                {
                    string[] d = str1.Split('\\');
                    string path = d.Last();
                    File.Copy(str1, Application.StartupPath + "\\images\\" + path);//拷贝一份存入数据库
                    sr.Photo_Path = path;                  
                }               
                ddc.SubmitChanges();
                MessageBox.Show("修改成功");
                clear();
            }
            catch
            {
                MessageBox.Show("此照片已经存在！请更改照片名字");
            } 
 
        }
        void clear()
        {
            txt_addr.Text = "";
            cob_dep.SelectedIndex = 0;
            txt_edu.Text = "";
            txt_em.Text = "";
            txt_idnum.Text = "";
            cob_job.SelectedIndex = 0;
            txt_mob.Text = "";
            txt_name.Text = "";
            cob_nat.SelectedIndex = 0;
            txt_ph.Text = "";
            cob_sex.SelectedIndex = 0;
            cob_ty.SelectedIndex = 0;
            cob_zc.SelectedIndex = 0; 
        
        }
        /// <summary>
        /// 遍历员工编号，存入集合
        /// </summary>
        List<int> idlist = new List<int>();
        public void Getstadff()
        {
            foreach (var i in ddc.T_StaffRecords.Select(q => q.Staff_ID))
            {
                idlist.Add(i);
            }
        }
        int staffid;
     
        //up 【上一个】
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            Getstadff();
            int index = 0;
            foreach (var i in idlist)
            {
                if (i == staffid)
                    break;
                index++;
            }
            if (index >= 1)
            {
                staffid = idlist[index - 1];
               
            }
            else
            {
                staffid = idlist[idlist.Count - 1];
            }
            show(staffid);         
        }
        //down 【下一个】
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            Getstadff();
            int index = 0;
            foreach (var i in idlist)
            {
                if (i == staffid)
                    break;
                index++;
            }
            if (index == (idlist.Count-1))
            {
                staffid =idlist[0];              
            }
            else
            {
                staffid = idlist[index + 1];              
            }
            show(staffid);   
        }              
        /// <summary>
        /// 添加照片
        /// </summary>
        string str1 = "";
        private void pictureBox1_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.ShowDialog();
                str1 = openFileDialog1.FileName;
                pictureBox1.Image = Image.FromFile(str1);
            }
            catch
            {
                MessageBox.Show("请选择正确的照片路径！");
            }
        }

        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.ShowDialog();
                str1 = openFileDialog1.FileName;
                pictureBox1.Image = Image.FromFile(str1);
            }
            catch
            {
                MessageBox.Show("请选择正确的照片路径！");
            }
        }

        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            MessageBox.Show("打印机不可用！");
        }

        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            toolStripButton3.Enabled = false;
        }
    }
}
