﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="list.aspx.cs" Inherits="Web.admin.k_article.list" %>
<%@ Register src="~/kzcms/admin/Menu.ascx" tagname="Menu" tagprefix="uc1"  %>
<%@ Register src="~/kzcms/admin/Head.ascx" tagname="Head" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>内容列表 - <%=Kscor.Common.Config.Systemname%></title>
    <link href="/kzcms/css/commons.css" type="text/css" rel="stylesheet" />
    <link href="/kzcms/css/style.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/kzcms/artDialog/skins/default.css" type="text/css" />
    <script type="text/javascript" src="/kzcms/js/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="/kzcms/artDialog/jquery.artDialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Dialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/iframeTools.source.js"></script>
    <script type="text/javascript" src="/kzcms/js/Common.js"></script>
    <script type="text/javascript" src="/kzcms/js/Tips.js"></script>
    <script type="text/javascript">
        var ChannelID = <%=ChannelID %>;
        var PageIndex = <%=PageIndex %>;
        var PageSize = 15;
        var PageList = [];
        var AllCount = 0;
        $(document).ready(function () {
            $(".tab_nav a").click(function () {
                var index = $(this).parent("li").index();
                $(".tab_con").eq(index).show().siblings(".tab_con").hide();
                $(".tab_nav li").eq(index).addClass("selected").siblings().removeClass("selected");
            });

            $("#CheckAll").live("click", function () {
                var obj = $(this).find("b");
                if (obj.html() == "全选") {
                    $("input[name=checkbox]:not(:disabled)").prop("checked", true);
                    obj.html("取消");
                } else {
                    $("input[name=checkbox]").prop("checked", false);
                    obj.html("全选");
                }
            });

            $(".ArticleTitle").live("click",function(){
                var id = $(this).attr("AID");
                ShowModify(id);
            });

            $("#DelChannel").click(function(){
                var id = $(this).attr("CID");
                _Dialog.Confirm("确认要删除本栏目吗？<br><br>只有当栏目下没有任何文章的时候才可以被删除", function () { DelChannel(id); }, function () { });
            });

            $("#DelAll").click(function () {
                var IDList = "";
                $("input[name=checkbox]:checked").each(function () {
                    IDList += $(this).attr("mid") + ",";
                });
                if (IDList == "") {
                    _Dialog.Alert("请选择要删除的文章");
                } else {
                    _Dialog.Confirm("确认要删除选中的文章吗？", function () { DelList(IDList); }, function () { });
                }
            });

            $(".IsTop").live("click",function(){
                var id = $(this).attr("aid");
                var IsTop = $(this).attr("IsTop");
                Tuijian(id,IsTop);
            });

            $(".ViewPage").click(function(){
                var model = $(this).attr("model");
                showpagelist(model);
            });

            $("#btnSearch").click(function(){
                GetPageList();
            });

            GetPageList();



            $('#Add_list').hide(); //打开页面隐藏下拉列表
            $('#Add').hover(  //鼠标滑过导航栏目时
                function(){$('#Add_list').show();},
                function(){$('#Add_list').hide();}
            );
            $('#Add_list').hover(  //鼠标滑过下拉列表自身也要显示，防止无法点击下拉列表
                function(){$('#Add_list').show();},
                function(){$('#Add_list').hide();}
            );
        });

        function Tuijian(ID,IsTop) {
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Article.ashx",
                data: { Act: "Tuijian", ArticleID: ID, IsTop: IsTop },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Succeed(result.Msg, 2);
                        if(IsTop==1){
                            $("input[type=image][aid="+ID+"]").attr("src","/kzcms/images/istop.png").attr("IsTop",0);
                        }else{
                            $("input[type=image][aid="+ID+"]").attr("src","/kzcms/images/istop_.png").attr("IsTop",1);
                        }
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }

        function GetPageList() {
            _Dialog.Loading("数据载入中...");
            var keyword = $("#txtKeywords").val();
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Article.ashx",
                dataType: "json",
                data: { Act: "GetPageList",PageSize:PageSize,PageIndex: PageIndex,ChannelID:ChannelID,keyword:escape(keyword)},
                success: function (result) {
                    dialoading.close();
                    PageList = result.List;
                    AllCount = result.AllCount;
                    showpagelist("txt");
                },
                error: function () { },
                cache: false
            });
        }


        function showpagelist(model)
        {
            var html = "",PageStr="",IsTop="",Img="",Modeltype="",State="",Tips="";
            if (PageList.length > 0) {
                if(model=="img"){
                    for (var i = 0; i < PageList.length; i++) {
                        Img = PageList[i].Img==""?"/kzcms/images/noimg.gif":unescape(PageList[i].Img);
                        switch(PageList[i].State)
                        {
                            case "0":State="<font>正常</font>";break;
                            case "1":State="<font color=#red>隐藏</font>";break;
                            case "2":State="<font color=#green>定时发布</font>(" + unescape(PageList[i].Tasktime)+")";break;
                        }
                        Tips = "<img src="+Img+">"
                        Img = Img.replace("/uploadfiles/","/uploadfiles/_thumbs/")
                        IsTop = PageList[i].IsTop==1?"<input IsTop=\"0\" aid=\"" + PageList[i].ID + "\" type=\"image\" title=\"取消推荐\" src=\"/kzcms/images/istop.png\" style=\"border-width:0px;\" class=\"IsTop\">":"<input IsTop=\"1\" aid=\"" + PageList[i].ID + "\" type=\"image\" title=\"推荐\" src=\"/kzcms/images/istop_.png\" style=\"border-width:0px;\" class=\"IsTop\">";
                        html += "<tr>";
                        html += "<td align=\"center\"><input mid=\"" + PageList[i].ID + "\" type=\"checkbox\" name=\"checkbox\"></td>";
                        html += "<td align=\"left\"><img src=\""+Img+"\" style=\"width:96px;\" onmouseover=\"showtips(this,'"+Tips+"',"+PageList[i].ID+",200)\">["+unescape(PageList[i].Type)+"]<a href=\"/kzcms/admin/k_article/modify.aspx?channelid="+ChannelID+"&articleid=" + PageList[i].ID + "\">" + unescape(PageList[i].Title) + "</a></td>";
                        html += "<td align=\"center\">" + State + "</td>";
                        html += "<td align=\"center\">" + unescape(PageList[i].Addtime) + "</td>";
                        html += "<td align=\"center\">" + IsTop + "</td>";
                        html += "</tr>";
                    }
                }else{
                    for (var i = 0; i < PageList.length; i++) {
                        switch(PageList[i].State)
                        {
                            case "0":State="<font>正常</font>";break;
                            case "1":State="<font color=#red>隐藏</font>";break;
                            case "2":State="<font color=#green>定时发布</font>(" + unescape(PageList[i].Tasktime)+")";break;
                        }
                        IsTop = PageList[i].IsTop==1?"<input IsTop=\"0\" aid=\"" + PageList[i].ID + "\" type=\"image\" title=\"取消推荐\" src=\"/kzcms/images/istop.png\" style=\"border-width:0px;\" class=\"IsTop\">":"<input IsTop=\"1\" aid=\"" + PageList[i].ID + "\" type=\"image\" title=\"推荐\" src=\"/kzcms/images/istop_.png\" style=\"border-width:0px;\" class=\"IsTop\">";
                        html += "<tr>";
                        html += "<td align=\"center\"><input mid=\"" + PageList[i].ID + "\" type=\"checkbox\" name=\"checkbox\"></td>";
                        html += "<td align=\"left\">["+unescape(PageList[i].Type)+"]<a href=\"/kzcms/admin/k_article/modify.aspx?channelid="+ChannelID+"&articleid=" + PageList[i].ID + "\">" + unescape(PageList[i].Title) + "</a></td>";
                        html += "<td align=\"center\">" + State + "</td>";
                        html += "<td align=\"center\">" + unescape(PageList[i].Addtime) + "</td>";
                        html += "<td align=\"center\">" + IsTop + "</td>";
                        html += "</tr>";
                    }
                } 
            } else {
                html = "<tr><td align=\"center\" colspan=4>该栏目下没有任何文章</td></tr>";
            }
            $("#List tr").slice(1).remove();
            $("#List tr").after(html);
            if(AllCount>PageSize){
                PageStr = Pager(AllCount,PageSize,PageIndex);
                $(".ui-page").html(PageStr); 
            }
        }

        function DelList(IDList) {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Article.ashx",
                dataType: "json",
                data: { Act: "DelList", IDList: IDList },
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Succeed("删除成功", 1);
                        $("input[name=checkbox]:checked").each(function () {
                            $(this).parents("tr").remove();
                        });
                        setTimeout(function () { location.replace("/kzcms/admin/k_article/list.aspx?channelid="+ChannelID+""); }, 1000);
                    } else {
                        _Dialog.Alert("删除失败");
                    }
                },
                error: function () { },
                cache: false
            });
        }

        function Pager(AllCount, PageSize, Page) {
            var PageStr = "", MaxPage = 0, ShowPageNum = 5, k = 0,Url="/kzcms/admin/k_article/list.aspx?channelid="+ChannelID+"";
            Page = parseInt(Page);
            MaxPage = parseInt(AllCount / PageSize);
            if (AllCount % PageSize != 0) { MaxPage++; }
            PageStr = "<span>页数: " + Page + " / " + MaxPage + "</span>";
            PageStr += "<a href=\""+Url+"&pageindex=1\">首页</a>";
            PageStr += (Page - 1 > 0) ? "<a href=\""+Url+"&pageindex="+(Page - 1)+"\">上一页</a>" : "<a>上一页</a>";
            for (j = 0; j < MaxPage; j++) {
                if (k >= ShowPageNum) { break; }
                if (((Page - j - 3 <= 0) && (MaxPage - j - ShowPageNum >= 0)) || (MaxPage - j - ShowPageNum <= 0)) {
                    k++;
                    PageStr += (Page - j == 1) ? "<a class=\"ui-page-on\">" + (j + 1) + "</a>" : "<a href=\""+Url+"&pageindex="+(j + 1)+"\">" + (j + 1) + "</a>";
                }
            }
            PageStr += (Page - MaxPage < 0) ? "<a href=\""+Url+"&pageindex="+(Page + 1)+"\">下一页</a>" : "<a>下一页</a>";
            PageStr += "<a href=\""+Url+"&pageindex="+MaxPage+"\">尾页</a>";
            return PageStr;
	    }

        function DelChannel(ID) {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Channel.ashx",
                dataType: "json",
                data: { Act: "Del", ID: ID },
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Succeed("删除成功", 1);
                        setTimeout(function () { location.replace("/kzcms/admin/k_channel/add.aspx"); }, 1000);
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                },
                error: function () { },
                cache: false
            });
        }
    </script>
</head>
<body>
    <uc1:Head ID="Head" runat="server"  />
    <uc1:Menu ID="Menu" runat="server" />
    <div id="mright">
        <div class="navigation">后台首页 &gt; 内容管理 &gt; <%=Channelname%> &gt; 内容列表</div>
        <div class="tools_box">
	        <div class="tools_bar">
		        <div class="search_box">
			        <input type="text" ID="txtKeywords" class="txtInput">
                    <input type="button" ID="btnSearch" value="搜 索" class="btnSearch" />
		        </div>
		        <a href="/kzcms/admin/k_article/add.aspx?channelid=<%=ChannelID %>&modelid=<%=DefaultModelid %>" id="Add" class="tools_btn"><span><b class="add">添加</b></span></a>

				<div id="Add_list" class="core_menu" style="display:none;">
					<ul class="core_menu_list">
                        <%=ModelUrlList %>
					</ul>
				</div>
		        <a href="javascript:void(0);" id="CheckAll" class="tools_btn"><span><b class="all">全选</b></span></a>
                <a href="javascript:void(0);" id="DelAll" class="tools_btn"><span><b class="delete">删除选中记录</b></span></a>
                <a href="/kzcms/admin/k_channel/modify.aspx?ChannelID=<%=ChannelID %>" id="Update" class="tools_btn"><span><b class="import">修改本栏目</b></span></a>
                <a href="javascript:void(0);" id="DelChannel" class="tools_btn" CID="<%=ChannelID %>"><span><b class="recycle">删除本栏目</b></span></a>
            </div>
            <div class="select_box">
                视图：
                <a href="javascript:;" title="文字列表视图" model="txt" class="ViewPage"><img src="/kzcms/images/ico-show-txt.png" alt="文字列表视图" /></a>
                <a href="javascript:;" title="图像列表视图" model="img" class="ViewPage"><img src="/kzcms/images/ico-show-img.png" alt="图像列表视图" /></a>
	        </div>
        </div>

          <table  id="List" width="100%" border="0" cellspacing="0" cellpadding="0" class="msgtable">
              <tr>
                <th width="6%">选择</th>
                <th align="left">标题（点击修改）</th>
                <th width="12%">状态</th>
                <th width="12%">添加时间</th>
                <th width="12%">属性</th>
              </tr>
          </table>


        <div class="page_box">
            <div class="ui-page"></div> 
        </div>

    </div>
</body>
</html>
