﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="add.aspx.cs" Inherits="Web.admin.k_channel.add" %>
<%@ Register src="~/kzcms/admin/Menu.ascx" tagname="Menu" tagprefix="uc1"  %>
<%@ Register src="~/kzcms/admin/Head.ascx" tagname="Head" tagprefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>添加栏目 - <%=Kscor.Common.Config.Systemname%></title>
    <link href="/kzcms/css/commons.css" type="text/css" rel="stylesheet" />
    <link href="/kzcms/css/style.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/kzcms/artDialog/skins/default.css" type="text/css" />
    <script type="text/javascript" src="/kzcms/js/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="/kzcms/artDialog/jquery.artDialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Dialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Common.js"></script>
    <script type="text/javascript" src="/kzcms/js/pinyin.js"></script>
    <script type="text/javascript">
        var folder = "";
        $(document).ready(function () {
            $(".tab_nav a").click(function () {
                var index = $(this).parent("li").index();
                $(".tab_con").eq(index).show().siblings(".tab_con").hide();
                $(".tab_nav li").eq(index).addClass("selected").siblings().removeClass("selected");
            });

            $("#Channelname").keyup(function () {
                $("#Filename").val(codefans_net_CC2PY($(this).val()));
            });

            $("#btnSubmit").click(function () {
                Add();
            });


            $("#Back").click(function () {
                window.history.back();
            });

            GetListOrder();
            GetModelList();
        });

        function Add() {
            var Channelname = $("#Channelname").val() || "";
            var Filename = $("#Filename").val() || "";
            var Sortid = $("#Sortid").val() || "";
            var Remark = $("#Remark").val() || "";
            var ListTheme = $("#ListTheme").val() || "";
            var PageTheme = $("#PageTheme").val() || "";
            var ParentID = $("#ParentID").val() || 0;
            var ModelID = $("#ModelID").val() || 0;
            var Url = $("#Url").val() || "";
            var Showintop = $("#Showintop").attr("checked") == "checked" ? 1 : 0;
            var Showinbottom = $("#Showinbottom").attr("checked") == "checked" ? 1 : 0;
            var Target = $("#Target").val() || "";
            var SeoTitle = escape($("#SeoTitle").val());
            var SeoDescription = escape($("#SeoDescription").val());
            var SeoKeywords = escape($("#SeoKeywords").val());

            if (Filename == "") { _Dialog.Alert("请输入栏目简写"); return; }
            if (ModelID <= 0) { _Dialog.Alert("请选择默认模型"); return; }
            if (Channelname == "") { _Dialog.Alert("请输入栏目名"); return; }
            if (Sortid <= 0) { _Dialog.Alert("排序必须为正整数"); return; }

            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Channel.ashx",
                data: { Act: "Add", ModelID: ModelID, Channelname: escape(Channelname), Sortid: Sortid, Remark: escape(Remark), ListTheme: escape(ListTheme), PageTheme: escape(PageTheme), Url: escape(Url), Showintop: Showintop, Showinbottom: Showinbottom, Target: escape(Target), Filename: escape(Filename), ParentID: ParentID, SeoTitle: SeoTitle, SeoDescription: SeoDescription, SeoKeywords: SeoKeywords },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Confirm("添加成功，是否继续添加", function () { location.replace("add.aspx"); }, function () { location.replace("/kzcms/admin/main.aspx"); 
                        });
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }


        function GetListOrder() {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Channel.ashx",
                dataType: "json",
                data: { Act: "GetListOrder" },
                success: function (result) {
                    var html = "<option value=\"0\">作为顶级栏目</option>", StringOfChar = "";
                    for (var i = 0; i < result.length; i++) {
                        StringOfChar = "";
                        if (result[i].Parentid == 0) {
                            html += "<option value=\"" + result[i].ID + "\">" + unescape(result[i].Name) + "</option>";
                        } else {
                            for (var j = 1; j < result[i].Depth; j++) {
                                StringOfChar += "&nbsp;&nbsp;";
                            }
                            html += "<option value=\"" + result[i].ID + "\">" + StringOfChar + "├ " + unescape(result[i].Name) + "</option>";
                        }
                    }
                    $("#ParentID").html(html);
                },
                error: function () { },
                cache: false
            });
        }

        function GetModelList() {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Model.ashx",
                dataType: "json",
                data: { Act: "GetList", State: 1 },
                success: function (result) {
                    var html = "";
                    for (var i = 0; i < result.length; i++) {
                        html += "<option value=\"" + result[i].ID + "\">" + unescape(result[i].Name) + "</option>";
                    }
                    $("#ModelID").html(html);
                },
                error: function () { },
                cache: false
            });
        }
    </script>
</head>
<body>
    <uc1:Head ID="Head" runat="server"  />
    <uc1:Menu ID="Menu" runat="server" />
    <div id="mright">
        <div class="navigation">后台首页 &gt; 内容管理 &gt; 添加栏目</div>
        <div id="contentTab">
            <ul class="tab_nav">
                <li class="selected"><a href="javascript:;">基本信息</a></li>
                <li><a href="javascript:;">SEO选项</a></li>
            </ul>

            <div class="tab_con" style="display:block;">
                <table class="form_table">
                    <col width="150px"/>
                    <tbody>
                    <tr>
                        <th>栏目名称：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:120px" id="Channelname" />
                            <label>设置栏目名称</label>
                        </td>
                    </tr>
                    <tr>
                        <th>英文简写：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:120px" id="Filename" />
                            <label>用于地址栏显示，只能为字母数字组合</label>
                        </td>
                    </tr>
                    <tr>
                        <th>父级栏目：</th>
                        <td>
                            <select id="ParentID"><option value="0">作为顶级栏目</option></select>
                            <label></label>
                        </td>
                    </tr>
                    <tr>
                        <th>栏目模型：</th>
                        <td>
                            <select id="ModelID"></select>
                            <label></label>
                        </td>
                    </tr>
                    
                    <tr>
                        <th>导航位置：</th>
                        <td>
                            <input type="checkbox" id="Showintop" />顶部 <input type="checkbox" id="Showinbottom" />  底部 
                            <label></label>
                        </td>
                    </tr>
                    <tr>
                        <th>外部链接：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:380px" id="Url" />
                            <label>留空则为普通栏目</label>
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">是否新窗口打开：</th>
                        <td>
                            <select id="Target"><option value="_blank">_blank</option><option value="_self">_self</option></select>
                            <label>新页面打开方式</label>
                        </td>
                    </tr>
                    <tr>
                        <th>排序号：</th>
                        <td>
                            <input type="text" class="txtInput" value="99" style="width:60px" id="Sortid" />
                            <label>填写排序号</label>
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">栏目说明：</th>
                        <td>
                            <textarea style="width:380px;height:80px;" id="Remark" name="Remark"></textarea>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>


            <div class="tab_con" style="display:none;">
                <table class="form_table">
                    <col width="150px"/>
                    <tbody>
                    <tr>
                        <th>浏览器标题(Title)：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:380px" id="SeoTitle" />
                            <label>浏览器标题(Title)，有利于SEO。可以使用 ${sitename} ${channelname} 标签</label>
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">关键字(Meta Keywords)：</th>
                        <td>
                            <textarea style="width:380px;height:60px;" id="SeoKeywords" name="SeoKeywords"></textarea>
                            <label>Keywords 出现在页面头部的 Meta 标签中，有利于SEO，多个关键字间请用半角逗号 "," 隔开</label>
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">描述(Meta Description)：</th>
                        <td>
                            <textarea style="width:380px;height:60px;" id="SeoDescription" name="SeoDescription"></textarea>
                            <label>Description 出现在页面头部的 Meta 标签中，有利于SEO</label>
                        </td>
                    </tr>
                    <tr>
                        <th>列表页模板：</th>
                        <td>
                            <input type="text" class="txtInput" value="List.html" style="width:380px" id="ListTheme" />
                            <label></label>
                        </td>
                    </tr>
                    <tr>
                        <th>内容页模板：</th>
                        <td>
                            <input type="text" class="txtInput" value="Article.html" style="width:380px" id="PageTheme" />
                            <label></label>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>



            <div class="foot_btn_box">
                <table class="form_table">
                    <col width="150px"/>
                    <tbody>
                    <tr>
                        <th></th>
                        <td><input type="button" value="  提交  " class="btnSubmit" id="btnSubmit" />
                        &nbsp;&nbsp;&nbsp;&nbsp;
                        <input type="button" value="  返回  " class="btnSubmit" id="Back" /></td>
                    </tr>
                    </tbody>
                </table>
            </div>


        </div>
    </div>
</body>
</html>
