﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="modify.aspx.cs" Inherits="Web.admin.k_config.modify" %>
<%@ Register src="~/kzcms/admin/Menu.ascx" tagname="Menu" tagprefix="uc1"  %>
<%@ Register src="~/kzcms/admin/Head.ascx" tagname="Head" tagprefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>系统设置 - <%=Kscor.Common.Config.Systemname%></title>
    <link href="/kzcms/css/commons.css" type="text/css" rel="stylesheet" />
    <link href="/kzcms/css/style.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/kzcms/artDialog/skins/default.css" type="text/css" />
    <script type="text/javascript" src="/kzcms/js/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="/kzcms/artDialog/jquery.artDialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Dialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Common.js"></script>
    <script type="text/javascript">
        var Feedback = "<%=Feedback %>";
        var Search = "<%=Search %>";
        var List = "<%=List %>";
        var ListPage = "<%=ListPage %>";
        var Article = "<%=Article %>";
        $(document).ready(function () {
            $(".tab_nav a").click(function () {
                var index = $(this).parent("li").index();
                $(".tab_con").eq(index).show().siblings(".tab_con").hide();
                $(".tab_nav li").eq(index).addClass("selected").siblings().removeClass("selected");
            });

            $("#btnSubmit").click(function () {
                UpdateRewrite();
            });

            $(".renew").click(function () {
                var obj = $(this).parent().parent().find("input");
                obj.val(obj.attr("val"));
            });

            $("#RewriteType").change(function () {
                var RewriteType = $(this).val()*1;
                switch (RewriteType) {
                    case 0:
                        $(this).parents("tr").next("tr").find("input").attr("readonly", false);
                        break;
                    case 1:
                        $(this).parents("tr").next("tr").find("input").attr("readonly", true);
                        $("#Feedback").val("Feedback.aspx");
                        $("#Search").val("Search/{Keyword}.aspx");
                        $("#List").val("{Channelname}.aspx");
                        $("#ListPage").val("{Channelname}/{Page}.aspx");
                        $("#Article").val("{Channelname}/{ArticleID}.aspx");
                        break;
                    case 2:
                        $(this).parents("tr").next("tr").find("input").attr("readonly", true);
                        $("#Feedback").val("Feedback");
                        $("#Search").val("Search/{Keyword}");
                        $("#List").val("{Channelname}/");
                        $("#ListPage").val("{Channelname}/{Page}/");
                        $("#Article").val("{Channelname}/{ArticleID}.html");
                        break;
                }
            });

            GetConfig();
        });

        function UpdateRewrite() {
            Feedback = $("#Feedback").val();
            Search = $("#Search").val();
            List = $("#List").val();
            ListPage = $("#ListPage").val();
            Article = $("#Article").val();
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Rewrite.ashx",
                data: { Act: "Update", Feedback: escape(Feedback), Search: escape(Search), List: escape(List), ListPage: escape(ListPage), Article: escape(Article) },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        //_Dialog.Succeed(result.Msg, 2);
                        Update();
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }

        function Update() {
            var Sitename = $("#Sitename").val() || "";
            var Icp = $("#Icp").val() || "";
            var StatScript = $("#StatScript").val() || "";
            var Copyright = $("#Copyright").val() || "";
            var SeoTitle = $("#SeoTitle").val() || "";
            var SeoKeywords = $("#SeoKeywords").val() || "";
            var SeoDescription = $("#SeoDescription").val() || "";
            var CacheTime = $("#CacheTime").val() || 0;
            var SitemapTime = $("#SitemapTime").val() || 0;
            var Url = $("#Url").val() || "";
            var OpenFeedback = $("#OpenFeedback").attr("checked") == "checked" ? 1 : 0;
            var CheckFeedback = $("#CheckFeedback").attr("checked") == "checked" ? 1 : 0;
            var CodeAdmin = $("#CodeAdmin").attr("checked") == "checked" ? 1 : 0;
            var CodeFeedback = $("#CodeFeedback").attr("checked") == "checked" ? 1 : 0;
            var RewriteType = $("#RewriteType").val() || 0;

            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Config.ashx",
                data: { Act: "Update", Sitename: escape(Sitename), Icp: escape(Icp), StatScript: escape(StatScript), Copyright: escape(Copyright), SeoTitle: escape(SeoTitle), SeoKeywords: escape(SeoKeywords), SeoDescription: escape(SeoDescription), CacheTime: CacheTime, OpenFeedback: OpenFeedback, CheckFeedback: CheckFeedback, SitemapTime: SitemapTime, Url: escape(Url), CodeAdmin: CodeAdmin, CodeFeedback: CodeFeedback, RewriteType: RewriteType },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Succeed(result.Msg, 2);
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }

        function GetConfig() {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Config.ashx",
                dataType: "json",
                data: { Act: "Get" },
                success: function (result) {
                    $("#Sitename").val(unescape(result.Sitename));
                    $("#Icp").val(unescape(result.Icp));
                    $("#StatScript").val(unescape(result.StatScript));
                    $("#Copyright").val(unescape(result.Copyright));
                    $("#SeoTitle").val(unescape(result.SeoTitle));
                    $("#SeoKeywords").val(unescape(result.SeoKeywords));
                    $("#SeoDescription").val(unescape(result.SeoDescription));
                    $("#CacheTime").val(unescape(result.CacheTime));
                    $("#SitemapTime").val(result.SitemapTime);
                    $("#Url").val(unescape(result.Url));
                    $("#RewriteType").val(result.RewriteType);
                    if (result.CodeAdmin == 1) { $("#CodeAdmin").attr("checked", true); }
                    if (result.CodeFeedback == 1) { $("#CodeFeedback").attr("checked", true); }
                    
                    
                    if (result.OpenFeedback == 1) { $("#OpenFeedback").attr("checked", true); }
                    if (result.CheckFeedback == 1) { $("#CheckFeedback").attr("checked", true); }
                },
                error: function () { },
                cache: false
            });
        }
    </script>
</head>
<body>
    <uc1:Head ID="Head" runat="server"  />
    <uc1:Menu ID="Menu" runat="server" />
    <div id="mright">
        <div class="navigation">后台首页 &gt; 功能管理 &gt; 系统设置</div>
        <div id="contentTab">
            <ul class="tab_nav">
                <li class="selected"><a href="javascript:;">基本信息</a></li>
                <li><a href="javascript:;">SEO选项</a></li>
                <li><a href="javascript:;">高级选项</a></li>
            </ul>

            <div class="tab_con" style="display:block;">
                <table class="form_table">
                    <col width="150px"/>
                    <tbody>
                    <tr>
                        <th>网站名称：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:260px" id="Sitename" />
                            <label>设置网站名称</label>
                        </td>
                    </tr>
                    <tr>
                        <th>Url：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:260px" id="Url" />
                            <label>设置网站Url，末尾无需加上/</label>
                        </td>
                    </tr>
                    <tr>
                        <th>网站备案号：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:260px" id="Icp" />
                            <label>填写备案号</label>
                        </td>
                    </tr>
                    <tr>
                        <th>统计代码：</th>
                        <td>
                            <textarea style="width:380px;height:60px;" id="StatScript" name="StatScript"></textarea>
                            <label>填写备案号</label>
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">版权信息：</th>
                        <td>
                            <textarea style="width:380px;height:80px;" id="Copyright" name="Copyright"></textarea>
                            <label>支持html语法，可以使用以下标签：网站名：${sitename}，备案号：${icp}，统计代码：${statscript}</label>
                        </td>
                    </tr>

                    
                    </tbody>
                </table>
            </div>

            <div class="tab_con" style="display:none;">
                <table class="form_table">
                    <col width="150px"/>
                    <tbody>
                    <tr>
                        <th>浏览器标题(Title)：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:380px" id="SeoTitle" />
                            <label>浏览器标题(Title)，有利于SEO</label>s
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">关键字(Meta Keywords)：</th>
                        <td>
                            <textarea style="width:380px;height:60px;" id="SeoKeywords" name="SeoKeywords"></textarea>
                            <label>Keywords 出现在页面头部的 Meta 标签中，有利于SEO，多个关键字间请用半角逗号 "," 隔开</label>
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">描述(Meta Description)：</th>
                        <td>
                            <textarea style="width:380px;height:60px;" id="SeoDescription" name="SeoDescription"></textarea>
                            <label>Description 出现在页面头部的 Meta 标签中，有利于SEO</label>
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">Url重写方式：</th>
                        <td>
                            <select id="RewriteType" name="RewriteType">
                                <option value=1>aspx后缀</option>
                                <option value=2>无后缀</option>
                                <option value=0>自定义</option>
                            </select>
                            <label>无后缀模式需要服务器支持</label>
                        </td>
                    </tr>
                    <tr id="RewriteList">
                        <th valign="top"></th>
                        <td>
                            栏目列表 &nbsp; &nbsp;<input type="text" class="txtInput" style="width:380px" id="List" value="<%=List %>" />     &nbsp; &nbsp;参数 {Channelname} {ChannelID}必选其一<br />
                            栏目分页 &nbsp; &nbsp;<input type="text" class="txtInput" style="width:380px" id="ListPage" value="<%=ListPage %>" />     &nbsp; &nbsp;参数 {Channelname} {ChannelID}必选其一；参数{Page}必选<br />
                            文章内容 &nbsp; &nbsp;<input type="text" class="txtInput" style="width:380px" id="Article" value="<%=Article %>" />     &nbsp; &nbsp;参数 {Articlename} {ArticleID}必选其一；参数{Channelname}可选<br />
                            搜索页面 &nbsp; &nbsp;<input type="text" class="txtInput" style="width:380px" id="Search" value="<%=Search %>"/>     &nbsp; &nbsp;参数 {Keyword} 必选<br />
                            留言页面 &nbsp; &nbsp;<input type="text" class="txtInput" style="width:380px" id="Feedback" value="<%=Feedback %>" />     &nbsp; &nbsp;<br />
                            <label></label>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <div class="tab_con" style="display:none;">
                <table class="form_table">
                    <col width="150px"/>
                    <tbody>
                    <tr>
                        <th>开启缓存：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:120px" id="CacheTime" />  缓存时间（分钟）
                            <label>设置缓存，0表示不缓存</label>
                        </td>
                    </tr>
                    <tr>
                        <th>自动更新网站地图：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:120px" id="SitemapTime" /> 更新频率（分钟）
                            <label>设置网站地图更新，0表示不自动更新</label>
                        </td>
                    </tr>
                    <tr>
                        <th>开启留言：</th>
                        <td>
                            <input type="checkbox" name="OpenFeedback" id="OpenFeedback"  />  允许留言
                            <input type="checkbox" name="CheckFeedback" id="CheckFeedback"  />  是否需要审核
                            <label></label>
                        </td>
                    </tr>
                    <tr>
                        <th>验证码：</th>
                        <td>
                            <input type="checkbox" name="CodeAdmin" id="CodeAdmin"  />  后台登录
                            <input type="checkbox" name="CodeFeedback" id="CodeFeedback"  />  在线留言
                            <label>是否需要填写验证码</label>
                        </td>
                    </tr>

                    </tbody>
                </table>
            </div>
           
            <div class="foot_btn_box">
                <table class="form_table">
                    <col width="150px"></col>
                    <tbody>
                    <tr>
                        <th></th>
                        <td><input type="button" value="  提交  " class="btnSubmit" id="btnSubmit" /></td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
