﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="list.aspx.cs" Inherits="Web.admin.k_link.list" %>
<%@ Register src="~/kzcms/admin/Menu.ascx" tagname="Menu" tagprefix="uc1"  %>
<%@ Register src="~/kzcms/admin/Head.ascx" tagname="Head" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>友情链接列表 - <%=Kscor.Common.Config.Systemname%></title>
    <link href="/kzcms/css/commons.css" type="text/css" rel="stylesheet" />
    <link href="/kzcms/css/style.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/kzcms/artDialog/skins/default.css" type="text/css" />
    <script type="text/javascript" src="/kzcms/js/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="/kzcms/artDialog/jquery.artDialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Dialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Common.js"></script>

    <script type="text/javascript">
        var PageIndex = <%=PageIndex %>,PageSize = 10,PageList = [],AllCount = 0,PageStr="";
        $(document).ready(function () {
            $(".tab_nav a").click(function () {
                var index = $(this).parent("li").index();
                $(".tab_con").eq(index).show().siblings(".tab_con").hide();
                $(".tab_nav li").eq(index).addClass("selected").siblings().removeClass("selected");
            });

            $("#CheckAll").live("click", function () {
                var obj = $(this).find("b");
                if (obj.html() == "全选") {
                    $("input[name=checkbox]:not(:disabled)").prop("checked", true);
                    obj.html("取消");
                } else {
                    $("input[name=checkbox]").prop("checked", false);
                    obj.html("全选");
                }
            });

            $("#DelAll").click(function () {
                var IDList = "";
                $("input[name=checkbox]:checked").each(function () {
                    IDList += $(this).attr("mid") + ",";
                });
                if (IDList == "") {
                    _Dialog.Alert("请选择要删除的模型");
                } else {
                    _Dialog.Confirm("确认要删除选中的模型吗？<br><br>选中模型的<b>扩展属性</b>、模型下的<font color=red><b>所有数据</b></font>也将被删除", function () { DelList(IDList); }, function () { });
                }
            });

            GetPageList();
        });


        function GetPageList() {
            _Dialog.Loading("数据载入中...");
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Link.ashx",
                dataType: "json",
                data: { Act: "GetPageList",PageSize:PageSize,PageIndex: PageIndex },
                success: function (result) {
                    dialoading.close();
                    PageList = result.List;
                    AllCount = result.AllCount;

                    if (PageList.length > 0) {
                        var html = "", Enabled = "", Show = "";
                        for (var i = 0; i < PageList.length; i++) {
                            Show = PageList[i].State == 1 ? "" : "<span style=\"color:#ff0000\">未审核</span>";
                            html += "<tr>";
                            html += "<td align=\"center\"><input mid=\"" + PageList[i].ID + "\" type=\"checkbox\" name=\"checkbox\"></td>";
                            html += "<td align=\"left\"><a href=\"/kzcms/admin/k_link/modify.aspx?id=" + PageList[i].ID + "\">" + unescape(PageList[i].Name) + "" + Show + "</a></td>";
                            html += "<td align=\"center\"><a target=\"_blank\" href=\"" + unescape(PageList[i].Url) + "\">" + unescape(PageList[i].Url) + "</a></td>";
                            html += "<td align=\"center\"><img src=\"" + unescape(PageList[i].Logo) + "\"</td>";
                            html += "<td align=\"center\">" + PageList[i].Sortid + "</td>";
                            html += "<td align=\"center\">" + (PageList[i].ShowDefault == 1 ? "是" : "否") + "</td>";
                            html += "</tr>";
                        }
                    } else {
                        html = "<tr><td align=\"center\" colspan=6>没有任何友情链接</td></tr>";
                    }
                    //$("#List").append(html);
                    $("#List tr").slice(1).remove();
                    $("#List tr").after(html);
                    if(AllCount>PageSize){
                        PageStr = Pager(AllCount,PageSize,PageIndex);
                        $(".ui-page").html(PageStr); 
                    }
                },
                error: function () { },
                cache: false
            });
        }

        function DelList(IDList) {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Link.ashx",
                dataType: "json",
                data: { Act: "DelList", IDList: IDList },
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Succeed("删除成功", 1);
                        $("input[name=checkbox]:checked").each(function () {
                            $(this).parents("tr").remove();
                        });
                        setTimeout(function () { location.replace("list.aspx"); }, 1000);
                    } else {
                        _Dialog.Alert("删除失败");
                    }
                },
                error: function () { },
                cache: false
            });
        }

        function Pager(AllCount, PageSize, Page) {
            var PageStr = "", MaxPage = 0, ShowPageNum = 5, k = 0,Url="/kzcms/admin/k_link/list.aspx?";
            Page = parseInt(Page);
            MaxPage = parseInt(AllCount / PageSize);
            if (AllCount % PageSize != 0) { MaxPage++; }
            PageStr = "<span>页数: " + Page + " / " + MaxPage + "</span>";
            PageStr += "<a href=\""+Url+"&pageindex=1\">首页</a>";
            PageStr += (Page - 1 > 0) ? "<a href=\""+Url+"&pageindex="+(Page - 1)+"\">上一页</a>" : "<a>上一页</a>";
            for (j = 0; j < MaxPage; j++) {
                if (k >= ShowPageNum) { break; }
                if (((Page - j - 3 <= 0) && (MaxPage - j - ShowPageNum >= 0)) || (MaxPage - j - ShowPageNum <= 0)) {
                    k++;
                    PageStr += (Page - j == 1) ? "<a class=\"ui-page-on\">" + (j + 1) + "</a>" : "<a href=\""+Url+"&pageindex="+(j + 1)+"\">" + (j + 1) + "</a>";
                }
            }
            PageStr += (Page - MaxPage < 0) ? "<a href=\""+Url+"&pageindex="+(Page + 1)+"\">下一页</a>" : "<a>下一页</a>";
            PageStr += "<a href=\""+Url+"&pageindex="+MaxPage+"\">尾页</a>";
            return PageStr;
	    }
    </script>
</head>
<body>
    <uc1:Head ID="Head" runat="server"  />
    <uc1:Menu ID="Menu" runat="server" />
    <div id="mright">
        <div class="navigation">后台首页 &gt; 功能管理 &gt; 友情链接列表</div>
        <div class="tools_box">
	        <div class="tools_bar">
		        <div class="search_box">
                    <!--
			        <input type="text" ID="txtKeywords" class="txtInput">
                    <input type="button" ID="btnSearch" value="搜 索" class="btnSearch" />
                    -->
		        </div>
		        <a href="/kzcms/admin/k_link/add.aspx" class="tools_btn"><span><b class="add">添加友情链接</b></span></a>
		        <a href="javascript:void(0);" id="CheckAll" class="tools_btn"><span><b class="all">全选</b></span></a>
                <a href="javascript:void(0);" id="DelAll" class="tools_btn"><span><b class="delete">批量删除</b></span></a>
            </div>
        </div>

          <table  id="List" width="100%" border="0" cellspacing="0" cellpadding="0" class="msgtable">
              <tr>
                <th width="6%">选择</th>
                <th align="left">网站名称</th>
                <th width="18%">Url</th>
                <th width="12%">Logo</th>
                <th width="10%">排序</th>
                <th width="10%">首页</th>
              </tr>
          </table>
        <div class="page_box">
            <div class="ui-page"></div> 
        </div>
    </div>
</body>
</html>
