﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="list.aspx.cs" Inherits="Web.admin.k_model.list" %>
<%@ Register src="~/kzcms/admin/Menu.ascx" tagname="Menu" tagprefix="uc1"  %>
<%@ Register src="~/kzcms/admin/Head.ascx" tagname="Head" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>模型列表 - <%=Kscor.Common.Config.Systemname%></title>
    <link href="/kzcms/css/commons.css" type="text/css" rel="stylesheet" />
    <link href="/kzcms/css/style.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/kzcms/artDialog/skins/default.css" type="text/css" />
    <script type="text/javascript" src="/kzcms/js/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="/kzcms/artDialog/jquery.artDialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Dialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Common.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $(".tab_nav a").click(function () {
                var index = $(this).parent("li").index();
                $(".tab_con").eq(index).show().siblings(".tab_con").hide();
                $(".tab_nav li").eq(index).addClass("selected").siblings().removeClass("selected");
            });

            $("#CheckAll").live("click", function () {
                var obj = $(this).find("b");
                if (obj.html() == "全选") {
                    $("input[name=checkbox]:not(:disabled)").prop("checked", true);
                    obj.html("取消");
                } else {
                    $("input[name=checkbox]").prop("checked", false);
                    obj.html("全选");
                }
            });

            $(".State").live("click", function () {
                var id = $(this).attr("aid");
                var State = $(this).attr("State");
                UpdateState(id, State);
            });

            $("#DelAll").click(function () {
                var IDList = "";
                $("input[name=checkbox]:checked").each(function () {
                    IDList += $(this).attr("mid") + ",";
                });
                if (IDList == "") {
                    _Dialog.Alert("请选择要删除的模型");
                } else {
                    _Dialog.Confirm("确认要删除选中的模型吗？<br><br>选中模型的<b>扩展属性</b>、模型下的<font color=red><b>所有数据</b></font>也将被删除", function () { DelList(IDList); }, function () { });
                }
            });

            GetConfig();
        });

        function UpdateState(ID, State) {
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Model.ashx",
                data: { Act: "UpdateState", ModelID: ID, State: State },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Succeed(result.Msg, 2);
                        if (State == 1) {
                            $("input[type=image][aid=" + ID + "]").attr("src", "/kzcms/images/istop.png").attr("State", 0);
                        } else {
                            $("input[type=image][aid=" + ID + "]").attr("src", "/kzcms/images/istop_.png").attr("State", 1);
                        }
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }

        function GetConfig() {
            _Dialog.Loading("数据载入中...");
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Model.ashx",
                dataType: "json",
                data: { Act: "GetList" },
                success: function (list) {
                    dialoading.close();
                    if (list.length > 0) {
                        var html = "", Enabled = "", IsBase = "", State = "";
                        for (var i = 0; i < list.length; i++) {
                            if (list[i].IsBase == "True") {
                                IsBase = "<span style=\"color:#ff0000\">[系统]</span>";
                                Enabled = "disabled";
                            }
                            else {
                                IsBase = "";
                                Enabled = "";
                            }
                            State = list[i].State == 1 ? "<input State=\"0\" aid=\"" + list[i].ID + "\" type=\"image\" title=\"禁用\" src=\"/kzcms/images/istop.png\" style=\"border-width:0px;\" class=\"State\">" : "<input State=\"1\" aid=\"" + list[i].ID + "\" type=\"image\" title=\"使用\" src=\"/kzcms/images/istop_.png\" style=\"border-width:0px;\" class=\"State\">";
                            html += "<tr>";
                            html += "<td align=\"center\"><input mid=\"" + list[i].ID + "\" type=\"checkbox\" name=\"checkbox\" " + Enabled + "></td>";
                            html += "<td align=\"left\"><a href=\"/kzcms/admin/k_model/modify.aspx?id=" + list[i].ID + "\">" + unescape(list[i].Name) + "</a>" + IsBase + "</td>";
                            html += "<td align=\"center\">" + unescape(list[i].Type) + "</td>";
                            html += "<td align=\"center\">" + list[i].AttributeCount + "</td>";
                            html += "<td align=\"center\">" + State + "</td>";
                            html += "<td align=\"center\">" + list[i].Sortid + "</td>";
                            html += "</tr>";
                        }
                    } else {
                        html = "<tr><td align=\"center\" rol=6></td></tr>";
                    }
                    $("#List").append(html);
                },
                error: function () { },
                cache: false
            });
        }

        function DelList(IDList) {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Model.ashx",
                dataType: "json",
                data: { Act: "DelList", IDList: IDList },
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Succeed("删除成功", 1);
                        $("input[name=checkbox]:checked").each(function () {
                            $(this).parents("tr").remove();
                        });
                        setTimeout(function () { location.replace("list.aspx"); }, 1000);
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                },
                error: function () { },
                cache: false
            });
        }
    </script>
</head>
<body>
    <uc1:Head ID="Head" runat="server"  />
    <uc1:Menu ID="Menu" runat="server" />
    <div id="mright">
        <div class="navigation">后台首页 &gt; 功能管理 &gt; 模型列表</div>
        <div class="tools_box">
	        <div class="tools_bar">
		        <div class="search_box">
                    <!--
			        <input type="text" ID="txtKeywords" class="txtInput">
                    <input type="button" ID="btnSearch" value="搜 索" class="btnSearch" />
                    -->
		        </div>
		        <a href="/kzcms/admin/k_model/add.aspx" class="tools_btn"><span><b class="add">添加模型</b></span></a>
		        <a href="javascript:void(0);" id="CheckAll" class="tools_btn"><span><b class="all">全选</b></span></a>
                <a href="javascript:void(0);" id="DelAll" class="tools_btn"><span><b class="delete">批量删除</b></span></a>
            </div>
        </div>

          <table  id="List" width="100%" border="0" cellspacing="0" cellpadding="0" class="msgtable">
              <tr>
                <th width="6%">选择</th>
                <th align="left">模型名称</th>
                <th width="12%">基类</th>
                <th width="12%">扩展属性数</th>
                <th width="12%">启用</th>
                <th width="12%">排序</th>
              </tr>
          </table>

    </div>
</body>
</html>
