﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="modify.aspx.cs" Inherits="Web.admin.k_model.modify" %>
<%@ Register src="~/kzcms/admin/Menu.ascx" tagname="Menu" tagprefix="uc1"  %>
<%@ Register src="~/kzcms/admin/Head.ascx" tagname="Head" tagprefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>修改模型 - <%=Kscor.Common.Config.Systemname%></title>
    <link href="/kzcms/css/commons.css" type="text/css" rel="stylesheet" />
    <link href="/kzcms/css/style.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/kzcms/artDialog/skins/default.css" type="text/css" />
    <script type="text/javascript" src="/kzcms/js/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="/kzcms/artDialog/jquery.artDialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Dialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Common.js"></script>
    <script type="text/javascript">
        var ModelID = <%=ModelID %>;
        var AttributeCount = 0;
        $(document).ready(function () {
            $(".tab_nav a").click(function () {
                var index = $(this).parent("li").index();
                $(".tab_con").eq(index).show().siblings(".tab_con").hide();
                $(".tab_nav li").eq(index).addClass("selected").siblings().removeClass("selected");
            });

            $("#btnSubmit").click(function () {
                Update();
            });

            $("#AddAttribute").click(function () {
                AddAttribute();
            });


            $(".DelAttribute").live("click",function () {
                var ID = $(this).attr("AID") * 1;
                _Dialog.Confirm("确认要删除该扩展属性吗？<br><br>所有该扩展属性的值也将被删除", function () { DelAttribute(ID); }, function () { });
            });


            $(".EditAttribute").live("click",function () {
                var obj= $(this);
                var ID = $(this).attr("AID") * 1;
                var AttributeName = $(this).parents(".td_c").find("td").eq(0).html();
                var AttributeSortid = $(this).parents(".td_c").find("td").eq(1).html();
                var AttributeRemark = $(this).parents(".td_c").find("td").eq(2).html();
                _Dialog.Form("修改扩展属性","<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"border_table\"><thead><tr><th>属性名</th><th>排序</th><th>说明</th></tr></thead><tbody id=\"nav_box\"><tr class=\"td_c\"><td><input type=\"text\" id=\"EditAttributeName\" value=\""+AttributeName+"\"></td><td><input type=\"text\" id=\"EditAttributeSortid\" value=\""+AttributeSortid+"\"></td><td><input type=\"text\" id=\"AttributeRemark\" value=\""+AttributeRemark+"\"></td></tr></tbody></table>", function () { UpdateAttribute(obj,ID); }, function () { });
            });


            $("#Back").click(function () {
                window.history.back();
            });

            Get();
        });

        function UpdateAttribute(obj,ID){
            var AttributeName = $("#EditAttributeName").val() || "";
            var AttributeSortid = $("#EditAttributeSortid").val() || 0;
            var AttributeRemark = $("#AttributeRemark").val() || "";
            if (AttributeName == "") { _Dialog.Alert("请输入扩展属性名"); return; }
            if (AttributeSortid <=0) { _Dialog.Alert("排序必须为正整数"); return; }
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Attribute.ashx",
                data: { Act: "Update", AttributeID: ID, AttributeName: escape(AttributeName), AttributeSortid: AttributeSortid, AttributeRemark:escape(AttributeRemark) },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        obj.parents(".td_c").find("td").eq(0).html(AttributeName);
                        obj.parents(".td_c").find("td").eq(1).html(AttributeSortid);
                        obj.parents(".td_c").find("td").eq(2).html(AttributeRemark);
                        _Dialog.Succeed("修改成功",1);
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }


        function Update() {
            var Modelname = $("#Modelname").val() || "";
            var Sortid = $("#Sortid").val() || "";
            var Remark = $("#Remark").val() || "";

            if (Modelname == "") { _Dialog.Alert("请输入模型名"); return; }
            if (Sortid <=0) { _Dialog.Alert("排序必须为正整数"); return; }
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Model.ashx",
                data: { Act: "Update", ModelID: ModelID, Modelname: escape(Modelname), Sortid: Sortid, Remark:escape(Remark) },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Confirm("修改成功，是否返回模型列表", function () { location.replace("list.aspx"); }, function () {  });
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }

        function Get() {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Model.ashx",
                dataType: "json",
                data: { Act: "Get",ModelID:ModelID },
                success: function (result) {
                    if(result.ID>0){
                        var list = result.AttributeList;
                        if (list.length > 0) {
                            var html = "", Enabled = "", IsBase = "";
                            for (var i = 0; i < list.length; i++) {
                                html += "<tr class=\"td_c\">";
                                html += "<td>" + unescape(list[i].Name) + "</td>";
                                html += "<td>" + list[i].Sortid + "</td>";
                                html += "<td>" + unescape(list[i].Remark) + "</td>";
                                html += "<td><button aid=\"" + list[i].ID + "\" type=\"button\" class=\"btnSelect EditAttribute\"><span class=\"edit\">修  改</span></button>&nbsp;&nbsp;&nbsp;&nbsp;<button aid=\"" + list[i].ID + "\" type=\"button\" class=\"btnSelect DelAttribute\"><span class=\"delete\">删 除</span></button></td>";
                                html += "</tr>";
                            }
                            $("#nav_box").prepend(html);
                            AttributeCount = list.length;
                            $(".tab_nav li").eq(1).find("a").html("扩展属性(" + AttributeCount + ")");
                        }


                        $("#ModelType").html(unescape(result.Type));
                        $("#Modelname").val(unescape(result.Name));
                        $("#Sortid").val(result.Sortid);
                        if(result.IsBase=="True"){
                            $("#ModelType").parents("tr").hide();
                            $("#Remark").parents("tr").hide();
                            $(".tab_nav li").eq(1).hide();
                        }
                    }else{
                        _Dialog.Alert(result.Msg);
                    }
                },
                error: function () { },
                cache: false
            });
        }

        function GetModelList() {
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Model.ashx",
                dataType: "json",
                data: { Act: "GetList", ModelID: ModelID,IsBase:1 },
                success: function (list) {
                    if (list.length > 0) {
                        var html = "", Enabled = "", IsBase = "";
                        for (var i = 0; i < list.length; i++) {
                            html += "<option value=\"" + unescape(list[i].Type) + "\">" + unescape(list[i].Name) + "</option>";
                        }
                        $("#ModelType").html(html);
                    }
                    Get();
                },
                error: function () { },
                cache: false
            });
        }


        function AddAttribute() {
            var AttributeName = $("#AttributeName").val();
            var AttributeRemark = $("#AttributeRemark").val();

            if (AttributeName == "") { _Dialog.Alert("请输入属性名"); return; }
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Attribute.ashx",
                dataType: "json",
                data: { Act: "Add", ModelID: ModelID, AttributeName: AttributeName, AttributeRemark: AttributeRemark},
                success: function (result) {
                    var html = "";
                    if (result.S=="1") {
                        html += "<tr class=\"td_c\">";
                        html += "<td>" + AttributeName + "</td>";
                        html += "<td>" + AttributeRemark + "</td>";
                        html += "<td><button aid=\"" + result.Msg + "\" type=\"button\" class=\"btnSelect DelAttribute\"><span class=\"delete\">删 除</span></button></td>";
                        html += "</tr>";
                        $("#nav_box tr:last").before(html);
                        $("#AttributeName").val("");
                        $("#AttributeRemark").val("");
                        AttributeCount++;
                        $(".tab_nav li").eq(1).find("a").html("扩展属性(" + AttributeCount + ")");
                    }else{
                        _Dialog.Alert(result.Msg);
                    }
                },
                error: function () { },
                cache: false
            });
        }

        function DelAttribute(ID) {
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Attribute.ashx",
                dataType: "json",
                data: { Act: "Del", ID: ID },
                success: function (result) {
                    if(result.S=="1"){
                        $("button[aid="+ID+"]").parent("td").parent("tr").remove();
                        AttributeCount--;
                        $(".tab_nav li").eq(1).find("a").html("扩展属性(" + AttributeCount + ")");
                    }else{
                        _Dialog.Alert(result.Msg);
                    }
                },
                error: function () { },
                cache: false
            });
        }
        
    </script>
</head>
<body>
    <uc1:Head ID="Head" runat="server"  />
    <uc1:Menu ID="Menu" runat="server" />
    <div id="mright">
        <div class="navigation">后台首页 &gt; 功能管理 &gt; 修改模型</div>
        <div id="contentTab">
            <ul class="tab_nav">
                <li class="selected"><a href="javascript:;">基本信息</a></li>
                <li><a href="javascript:;">扩展属性</a></li>
            </ul>

            <div class="tab_con" style="display:block;">
                <table class="form_table">
                    <col width="150px"></col>
                    <tbody>
                    <tr>
                        <th>模型名称：</th>
                        <td>
                            <input type="text" class="txtInput" style="width:120px" id="Modelname" />
                            <label>设置模型名称</label>
                        </td>
                    </tr>
                    <tr>
                        <th>基类：</th>
                        <td>
                            <span id="ModelType"></span>
                            <label></label>
                        </td>
                    </tr>
                    <tr>
                        <th>排序号：</th>
                        <td>
                            <input type="text" class="txtInput" value="99" style="width:60px" id="Sortid" />
                            <label>填写排序号</label>
                        </td>
                    </tr>
                    <tr>
                        <th valign="top">模型说明：</th>
                        <td>
                            <textarea style="width:380px;height:80px;" id="Remark" name="Remark"></textarea>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>


            <div class="tab_con" style="display:none;">
                <table class="form_table">
                    <col width="150px" />
                    <tbody>
                    <tr>
                        <th></th>
                        <td>
                            <table border="0" cellspacing="0" cellpadding="0" class="border_table">
                                <thead>
                                <tr>
                                    <th>属性名</th>
                                    <th>排序</th>
                                    <th>说明</th>
                                    <th>操作</th>
                                </tr>
                                </thead>
                                <tbody id="nav_box">
                                <tr class="td_c">
                                    <td><input id="AttributeName" type="text" value="" class="txtInput small" /></td>
                                    <td><input id="AttributeSortid" type="text" value="" class="txtInput small2" /></td>
                                    <td><input id="AttributeRemark" type="text" value="" class="txtInput small3" /></td>
                                    <td><button id="AddAttribute" type="button" class="btnSelect"><span class="add">添 加</span></button></td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <div class="foot_btn_box">
                <table class="form_table">
                    <col width="150px"></col>
                    <tbody>
                    <tr>
                        <th></th>
                        <td><input type="button" value="  提交  " class="btnSubmit" id="btnSubmit" />
                        &nbsp;&nbsp;&nbsp;&nbsp;
                        <input type="button" value="  返回  " class="btnSubmit" id="Back" /></td>
                    </tr>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</body>
</html>
