﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="list.aspx.cs" Inherits="Web.admin.k_theme.list" %>
<%@ Register src="~/kzcms/admin/Menu.ascx" tagname="Menu" tagprefix="uc1"  %>
<%@ Register src="~/kzcms/admin/Head.ascx" tagname="Head" tagprefix="uc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>模板列表 - <%=Kscor.Common.Config.Systemname%></title>
    <link href="/kzcms/css/commons.css" type="text/css" rel="stylesheet" />
    <link href="/kzcms/css/style.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="/kzcms/artDialog/skins/default.css" type="text/css" />
    <script type="text/javascript" src="/kzcms/js/jquery-1.7.1.min.js"></script>
    <script type="text/javascript" src="/kzcms/artDialog/jquery.artDialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Dialog.js"></script>
    <script type="text/javascript" src="/kzcms/js/Common.js"></script>

    <script type="text/javascript">
        $(document).ready(function () {
            $(".tab_nav a").click(function () {
                var index = $(this).parent("li").index();
                $(".tab_con").eq(index).show().siblings(".tab_con").hide();
                $(".tab_nav li").eq(index).addClass("selected").siblings().removeClass("selected");
            });

            $("#CheckAll").live("click", function () {
                var obj = $(this).find("b");
                if (obj.html() == "全选") {
                    $("input[name=checkbox]:not(:disabled)").prop("checked", true);
                    obj.html("取消");
                } else {
                    $("input[name=checkbox]").prop("checked", false);
                    obj.html("全选");
                }
            });

            $("#DelAll").click(function () {
                var IDList = "";
                $("input[name=checkbox]:checked").each(function () {
                    IDList += $(this).attr("mid") + ",";
                });
                if (IDList == "") {
                    _Dialog.Alert("请选择要删除的模型");
                } else {
                    _Dialog.Confirm("确认要删除选中的模型吗？<br><br>选中模型的<b>扩展属性</b>、模型下的<font color=red><b>所有数据</b></font>也将被删除", function () { DelList(IDList); }, function () { });
                }
            });

            GetList();
        });

        function Update() {
            var Sitename = $("#Sitename").val() || "";
            var Icp = $("#Icp").val() || "";
            var StatScript = $("#StatScript").val() || "";
            var Copyright = $("#Copyright").val() || "";
            var SeoTitle = $("#SeoTitle").val() || "";
            var SeoKeywords = $("#SeoKeywords").val() || "";
            var SeoDescription = $("#SeoDescription").val() || "";

            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Config.ashx",
                data: { Act: "Update", Sitename: escape(Sitename), Icp: escape(Icp), StatScript: escape(StatScript), Copyright: escape(Copyright), SeoTitle: escape(SeoTitle), SeoKeywords: escape(SeoKeywords), SeoDescription: escape(SeoDescription) },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        _Dialog.Succeed(result.Msg, 2);
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }

        function UpdateTheme(Theme) {
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Config.ashx",
                data: { Act: "UpdateTheme", Theme: escape(Theme) },
                dataType: "json",
                success: function (result) {
                    if (result.S == "1") {
                        GetList();
                        _Dialog.Succeed(result.Msg, 2);
                    } else {
                        _Dialog.Alert(result.Msg);
                    }
                }
            });
        }

        function DownloadTheme(Theme) {
            $.ajax({
                type: "Post",
                url: "/kzcms/admin/Server/Theme.ashx",
                data: { Act: "DownloadTheme", Theme: escape(Theme) },
                dataType: "html",
                success: function (result) {
                   // location.href = result;
                    _Dialog.Succeed("<div><a href=\"" + result + "\">导出成功，请点击下载</a></div>");
                }
            });
        }

        function GetList() {
            _Dialog.Loading("数据载入中...");
            $.ajax({
                type: "GET",
                url: "/kzcms/admin/Server/Theme.ashx",
                dataType: "json",
                data: { Act: "GetList" },
                success: function (list) {
                    dialoading.close();
                    if (list.length > 0) {
                        var html = "", Enabled = "", IsBase = "";
                        for (var i = 0; i < list.length; i++) {
                            html += "<div style=\"float:left;margin:10px; height:160px;border: 1px solid #C0C7D9;width:380px;\">";
                            html += "<div style=\"float:left; height:120px; width:160px; margin:10px;\"><img src=" + list[i].Img + " alt=\"主题预览\" /></div>";
                            html += "<div style=\"height:120px; margin:10px; text-align:left;\"><p>" + unescape(list[i].Themename) + "</p><p>作者：" + unescape(list[i].Author) + "  </p><p>主页：<a href=" + unescape(list[i].Siteurl) + " title=\"访问作者主页\" target=\"_blank\">" + unescape(list[i].Siteurl) + "</a>    </p><p>发布日期：" + unescape(list[i].Pubdate) + "</p><p><a href=\"javascript:;\" onclick=\"UpdateTheme('" + unescape(list[i].Dir) + "')\">使用</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"modify.aspx?theme=" + unescape(list[i].Dir) + "\">编辑</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"javascript:;\" onclick=\"DownloadTheme('" + unescape(list[i].Dir) + "')\">导出</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"javascript:;\" onclick=\"Del('" + unescape(list[i].Dir) + "')\">删除</a></p></div>";
                            html += "</div>";
                        }
                    } else {
                        html = "<div>没有任何模版</div>";
                    }
                    $("#List").html(html);
                },
                error: function () { },
                cache: false
            });
        }

        function Del(Theme) {
            _Dialog.Confirm("确认要删除本模板吗", function () {
                $.ajax({
                    type: "GET",
                    url: "/kzcms/admin/Server/Theme.ashx",
                    dataType: "json",
                    data: { Act: "Del", Theme: Theme },
                    success: function (result) {
                        if (result.S == "1") {
                            _Dialog.Succeed("删除成功", 1);
                            GetList();
                        } else {
                            _Dialog.Alert(result.Msg);
                        }
                    },
                    error: function () { },
                    cache: false
                });
             }, function () { });

        }
    </script>
</head>
<body>
    <uc1:Head ID="Head" runat="server"  />
    <uc1:Menu ID="Menu" runat="server" />
    <div id="mright">
        <div class="navigation">后台首页 &gt; 功能管理 &gt; 模板管理</div>


          <div  id="List">

          </div>

    </div>
</body>
</html>
