﻿var _Dialog = {
    Notice: function(content, t) {//提示框
        dianotice = art.dialog({ id: "notice", content: content, icon: "warning", lock: true, opacity: 0.1, time: t, title: false, fixed: true });
    },
    Loading: function(content) {//提示框
        dialoading = art.dialog({ id: "loading", content: content, icon: "loading", cancel: false, title: false, fixed: true });
    },
    Succeed: function(content, t) {
        artdialog = art.dialog({ id: "artdialog", content: content, icon: "succeed", lock: true, opacity: 0.1, time: t, fixed: true, title: false });
    },
    Show: function(content, t) {
        artmsg = art.dialog({ id: "artmsg", content: content, lock: false, opacity: 0.1, time: t, fixed: true, title: false });
    },
    Tips: function(content, classname, t) {
        if ($("#tips").length) {
            $("#tips").html(content).attr("class", classname).css('display', ''); ;
        } else {
            var mesW = document.createElement("div");
            mesW.id = "tips";
            mesW.innerHTML = content;
            mesW.className = classname;
            document.body.appendChild(mesW);
        }
        if (t > 0) { setTimeout(function() { $("#tips").hide(); }, t * 1000); }
    },
    Confirm: function(content, yes, no) {
        return artDialog({
            id: 'Confirm',
            icon: 'question',
            fixed: true,
            lock: true,
            opacity: .1,
            content: content,
            ok: function(here) {
                return yes.call(this, here);
            },
            cancel: function(here) {
                return no && no.call(this, here);
            }
        });
    },
    Form: function (title,content, yes, no) {
        return artDialog({
            id: 'Form',
            title:title,
            fixed: true,
            lock: true,
            opacity: .1,
            content: content,
            ok: function (here) {
                return yes.call(this, here);
            },
            cancel: function (here) {
                return no && no.call(this, here);
            }
        });
    },
    Prompt: function(content, yes, value) {
        value = value || '';
        var input;

        return artDialog({
            id: 'Prompt',
            icon: 'question',
            fixed: true,
            lock: true,
            opacity: .1,
            content: [
                '<div style="margin-bottom:5px;font-size:12px">',
                    content,
                '</div>',
                '<div>',
                    '<input value="',
                        value,
                    '" style="width:18em;padding:6px 4px" />',
                '</div>'
                ].join(''),
            init: function() {
                input = this.DOM.content.find('input')[0];
                input.select();
                input.focus();
            },
            ok: function(here) {
                return yes && yes.call(this, input.value, here);
            },
            cancel: true
        });
    },
    Alert: function(content) {
        return artDialog({
            id: 'Alert',
            icon: 'warning',
            fixed: true,
            lock: true,
            opacity: .1,
            content: content,
            ok: true,
            title:false,
            cancel:false
        });
    },
    ShowMask: function() {
        if ($("#mask").length) {
            _scrollHeight = Math.max(document.body.scrollHeight, document.documentElement.scrollHeight);
            _scrollWidth = Math.max(document.body.scrollWidth, document.documentElement.scrollWidth);
            $("#mask").css({ "width": _scrollWidth + "px", "height": _scrollHeight + "px" }).show(100);
        }
        else {
            var newMask = document.createElement("div");
            newMask.id = "mask";
            newMask.oncontextmenu = function() { return false; }; //屏蔽遮罩层右键
            newMask.onselectstart = function() { return false; }; //屏蔽遮罩层选择
            newMask.onmousedown = function() { return false; }; //屏蔽遮罩层鼠标按键
            newMask.style.position = "absolute";
            newMask.style.zIndex = "999";
            _scrollWidth = Math.max(document.body.scrollWidth, document.documentElement.scrollWidth);
            _scrollHeight = Math.max(document.body.scrollHeight, document.documentElement.scrollHeight);
            newMask.style.width = _scrollWidth + "px";
            newMask.style.height = _scrollHeight + "px";
            newMask.style.top = "0px";
            newMask.style.left = "0px";
            newMask.style.background = "#33393C";
            newMask.style.filter = "alpha(opacity=0)";
            newMask.style.opacity = "0";
            document.body.appendChild(newMask);
        }
    },
    HideMask: function() {
        $("#mask").hide();
    }
}