﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Managa.aspx.cs" Inherits="TotCms.Web.Office.Announce.Managa" %>

<%@ Register assembly="TotCms.Controls" namespace="TotCms.Controls" tagprefix="cc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>通知公告</title>
    <link href="../style/global.css" rel="stylesheet" type="text/css" />
    <link href="../../js/jquery-ui-1.8.10/css/ui-lightness/jquery-ui-1.8.10.custom.css" rel="stylesheet" type="text/css" />
    <script src="../../js/jquery-1.5.1.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.core.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.widget.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.datepicker.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/i18n/jquery.ui.datepicker-zh-CN.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('.dates').datepicker($.datepicker.regional["zh-CN"]);
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="br"></div>
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
    <div>
        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="1" class="border">
            <tr class="suphead">
                <td>
                    通知公告
                </td>
            </tr>
            <tr>
                <td class="fields_text">
                    发布单位:<asp:TextBox ID="tbDept" runat="server"></asp:TextBox>
                    &nbsp;&nbsp;标题:<asp:TextBox ID="tbTitle" runat="server"></asp:TextBox>
                     &nbsp;&nbsp;副标题:<asp:TextBox ID="tbSubHead" runat="server"></asp:TextBox>
                </td>   
            </tr>
            <tr>
                <td class="fields_text">
                    日 &nbsp;期 &nbsp;从:<asp:TextBox ID="tbStartDate" runat="server" CssClass="dates"></asp:TextBox>
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;到:<asp:TextBox ID="tbEndDate" runat="server" CssClass="dates"></asp:TextBox>
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<asp:Button ID="btnGo" runat="server" Text="查询" onclick="btnGo_Click" />
                </td>  
            </tr>
        </table>
    </div>
    <div>
        <table cellpadding="0" cellspacing="1" border="0" width="100%">
            <tr>
                <td class="topic"">
                    公告栏目：
                    <a href='?classid=0'>所有</a>
                    <asp:Repeater ID="rpClass" runat="server">
                    <ItemTemplate>
                    <a href='?classid=<%# Eval("id")%>'><%# Eval("Title")%></a>
                    </ItemTemplate>
                    </asp:Repeater>
                    &nbsp; 
                    <input type="button" class="button_blue" onclick="location.href='Announce_Add.aspx'" value="发新公告" />
                                
                </td>
            </tr>            
        </table>
    </div>
    <div>
        <asp:ListView ID="lvList" runat="server" ItemPlaceholderID="items" 
          DataKeyNames="id" onitemdeleting="lvList_ItemDeleting">
            <LayoutTemplate>
                <table cellpadding="0" cellspacing="1" border="0" width="100%" class="border">
                    <tr class="suphead">
                        <td width="8%">
                            重要
                        </td>
                        <td width="34%">
                            标题
                        </td>
                        <td width="16%">
                            发布单位
                        </td>
                        <td width="13%">
                            发布人
                        </td>
                        <td width="18%">
                            发布时间
                        </td>
                        <td width="11%">
                            编辑
                        </td>
                    </tr>
                    <asp:PlaceHolder runat="server" ID="items"></asp:PlaceHolder>
            </LayoutTemplate>
            <ItemTemplate>
                <tr class="lines" ondblclick="window.open('Announce_View.aspx?id=<%# Eval("id") %>', 'newwindow', 'height=600, width=800, top=100, left=400, toolbar=no, menubar=no, scrollbars=yes, resizable=no,location=no, status=no')">                   
                    <td>
                        <%# Convert.ToInt32(Eval("IsBold")) == 0 ? "" : "<span class=\"redbold\">!</span>"%>
                    </td>
                    <td style="text-align:left; padding-left:5px;">
                        <a href='Announce_View.aspx?id=<%#Eval("id")%>' style='font-size:<%#Eval("FontSize")%>px'><%#Eval("Title") %></a>
                    </td>
                     <td>
                        <%# Eval("DeptName")%>
                    </td>
                    <td>
                        <a href='../Staff/Staff_Show.aspx?id=<%#Eval("StaffId")%>'><%# Eval("UserName") %></a>
                    </td>      
                         
                     <td>
                        <%# Eval("PubDate")%>
                    </td>     
                    <td>
                    <a href='Announce_Add.aspx?id=<%# Eval("id")%>'>编辑</a>
                    |
						<asp:LinkButton ID="LinkButton2" OnLoad="Delete_Load" runat="server" CommandName="delete" CommandArgument='<%# Eval("id") %>'>删除</asp:LinkButton>
                    </td>                               
                </tr>
            </ItemTemplate>
            <EmptyDataTemplate>
                <table cellpadding="0" cellspacing="1" border="0" width="100%" class="border">
                    <tr class="suphead">
                        <td>
                            <h2>暂时没有数据</h2>
                        </td>
                    </tr>
                </table>
            </EmptyDataTemplate>
        </asp:ListView>
    </div>
    <cc1:Pager ID="Pager1" runat="server" GenerateFirstLastSection="True" 
      GenerateGoToSection="True" GenerateHiddenHyperlinks="False" 
      QueryStringParameterName="CurrentPage" OnCommand="pager_Command" 
      GoToStyle="text" OfClause="/" PageClause="页" PageSize="15" />
    </form>
</body>
</html>
