﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ToArchives.aspx.cs" Inherits="TotCms.Web.Office.Document.ToArchives" %>
<%@ Register assembly="TotCms.Controls" namespace="TotCms.Controls" tagprefix="cc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>公文归档管理</title>    
    <link href="../style/global.css" rel="stylesheet" type="text/css" />
    <link href="../../js/jquery-ui-1.8.10/css/ui-lightness/jquery-ui-1.8.10.custom.css" rel="stylesheet" type="text/css" />
    <script src="../../js/jquery-1.5.1.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.core.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.widget.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.datepicker.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/i18n/jquery.ui.datepicker-zh-CN.js" type="text/javascript"></script>
    <script type="text/javascript">
      $(function () {
        $('.dates').datepicker($.datepicker.regional["zh-CN"]);
      });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="br"></div>
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
    <div>
        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="1" class="border">
            <tr class="suphead">
                <td colspan="2">
                    公文归档
                </td>
            </tr>
            <tr>
                <td class="fields_text">分类：<asp:DropDownList ID="ddClassId" runat="server">
        </asp:DropDownList>
          &nbsp;日期 从：<asp:TextBox ID="tbStartDate" runat="server" CssClass="dates"></asp:TextBox>
                    到：<asp:TextBox ID="tbEndDate" runat="server" CssClass="dates"></asp:TextBox>
                    关键字：<asp:TextBox ID="tbKey" runat="server"></asp:TextBox>
                    <asp:Button ID="btnGo" runat="server" Text="查询" onclick="btnGo_Click" />
                &nbsp;</td>               
            </tr>
        </table>
    </div>
    <div>
        <asp:ListView ID="lvList" runat="server" ItemPlaceholderID="items" DataKeyNames="id">
            <LayoutTemplate>
                <table cellpadding="0" cellspacing="1" border="0" width="100%" class="border">
                    <tr class="suphead">                        
                        <td>
                            <asp:CheckBox ID="cbSelect" runat="server" OnCheckedChanged="CbSelectChanged" AutoPostBack="true" />
                        </td>
                        <td>标题</td>
                        <td>编号</td>
                        <td>登记人</td>
                        <td>登记机关</td>
                        <td>类别</td>
                        <td>密级</td>
                        <td>缓急</td>
                        <td>日期</td>
                        <td>归档</td>
                    </tr>
                    <asp:PlaceHolder runat="server" ID="items"></asp:PlaceHolder>
                </table>
            </LayoutTemplate>
            <ItemTemplate>
                <tr class="lines">                    
                    <td>
                        <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                            <ContentTemplate>
                                <asp:CheckBox ID="ChkId" runat="server" Checked="false" />
                            </ContentTemplate>
                            <Triggers>
                                <asp:AsyncPostBackTrigger ControlID="BtnSelect" EventName="Click" />
                            </Triggers>
                        </asp:UpdatePanel>
                        <asp:TextBox ID="ChkTxt" runat="server" CssClass="hidden" Text='<%# Eval("WfId") %>'></asp:TextBox>
                        <asp:TextBox ID="ChkIsSave" runat="server" CssClass="hidden" Text='<%# Eval("IsSave") %>'></asp:TextBox>
                    </td>
                    <td style="text-align:left; padding-left:5px;">
                        <a href='Issue_Show.aspx?id=<%# Eval("WfId") %>'><%# Eval("Title")%></a>
                    </td>
                    <td><%# Eval("Code")%></td>
                    <td><%# Eval("Writer")%></td>
                    <td><%# Eval("PubBy")%></td>
                    <td><%# Eval("Types")%></td>
                    <td><%# Eval("Encrypt")%></td>
                    <td><%# Eval("HuanJi")%></td>
                    <td><%# Eval("PubDate")%></td>
                    <td>
                        <%# Convert.ToInt32(Eval("IsSave")) == 0 ? "否" : "是"%>
                    </td>
                </tr>
            </ItemTemplate>
            <EmptyDataTemplate>
                <table cellpadding="0" cellspacing="1" border="0" width="100%" class="border">
                    <tr class="suphead">
                        <td>
                           暂时没有数据
                        </td>
                    </tr>
                </table>
            </EmptyDataTemplate>
        </asp:ListView>
        <div align="center">
            <asp:Button ID="BtnSelect" runat="server" Text="全选" OnClick="BtnSelect_Click" />
            <asp:DropDownList ID="BatRunType" runat="server">
                <asp:ListItem Text="批量归档" Value="bat2archive"></asp:ListItem>
                <asp:ListItem Text="批量删除" Value="bat2delete"></asp:ListItem>
            </asp:DropDownList>
            档案分类：
            <asp:DropDownList ID="ToClass" runat="server">
            </asp:DropDownList>
            <asp:Button ID="BtnRun" runat="server" Text="执行操作" OnClick="BtnRun_Click" OnClientClick="return confirm('确定执行吗?')" />
        </div>
        <cc1:Pager ID="Pager1" runat="server" GenerateFirstLastSection="True" 
      GenerateGoToSection="True" GenerateHiddenHyperlinks="False" 
      QueryStringParameterName="CurrentPage" OnCommand="pager_Command" 
      GoToStyle="text" OfClause="/" PageClause="页" PageSize="15" />
    </div>
    </form>
</body>
</html>
