﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Send_Box.aspx.cs" Inherits="TotCms.Web.Office.Mail.Send_Box" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<%@ Register assembly="TotCms.Controls" namespace="TotCms.Controls" tagprefix="cc1" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>收件箱</title>
    <link href="../style/global.css" rel="stylesheet" type="text/css" />
    <link href="../../js/jquery-ui-1.8.10/css/ui-lightness/jquery-ui-1.8.10.custom.css" rel="stylesheet" type="text/css" />
    <script src="../../js/jquery-1.5.1.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.core.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.widget.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.datepicker.min.js" type="text/javascript"></script>
    <script src="../../js/jquery-ui-1.8.10/js/i18n/jquery.ui.datepicker-zh-CN.js" type="text/javascript"></script>
    <script type="text/javascript">
      $(function () {
        $('.dates').datepicker($.datepicker.regional["zh-CN"]);
      });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <div class="br"></div>
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
    <div>
        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="1" class="border">
            <tr class="suphead">
                <td colspan="2">
                    发件箱
                </td>
            </tr>
            <tr>
                <td width="91%" class="fields_text">日期 从：<asp:TextBox ID="tbStartDate" runat="server" CssClass="dates"></asp:TextBox>
                    到：<asp:TextBox ID="tbEndDate" runat="server" CssClass="dates"></asp:TextBox>
                    关键字：<asp:TextBox ID="tbKey" runat="server"></asp:TextBox>
                    <asp:Button ID="btnGo" runat="server" Text="查询" onclick="btnGo_Click" />
                &nbsp; 
                <a href="Receive.aspx">收件箱</a>
                <a href="Send_Box.aspx">发件箱</a>
                </td>
                <td width="9%">
                    <a href="Send.aspx" class="btn">发新邮件&gt;</a>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <asp:ListView ID="lvList" runat="server" ItemPlaceholderID="items" OnItemCommand="lvList_ItemCommand" OnItemDataBound="lvList_ItemDataBound" DataKeyNames="id">
            <LayoutTemplate>
                <table cellpadding="0" cellspacing="1" border="0" width="100%" class="border">
                    <tr class="suphead">
                        <td>
                            <asp:CheckBox ID="cbSelect" runat="server" OnCheckedChanged="CbSelectChanged" AutoPostBack="true" />
                        </td>
                        <td width="15%">
                            收信人
                        </td>
                        <td width="45%">
                            标题
                        </td>
                        <td width="15%">
                            时间
                        </td>

                        <td width="15%">
                            操作
                        </td>
                    </tr>
                    <asp:PlaceHolder runat="server" ID="items"></asp:PlaceHolder>
                </table>
            </LayoutTemplate>
            <ItemTemplate>
                <tr class="lines">
                    <td>
                        <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                            <ContentTemplate>
                                <asp:CheckBox ID="ChkId" runat="server" Checked="false" />
                            </ContentTemplate>
                            <Triggers>
                                <asp:AsyncPostBackTrigger ControlID="BtnSelect" EventName="Click" />
                            </Triggers>
                        </asp:UpdatePanel>
                        <asp:TextBox ID="ChkTxt" runat="server" CssClass="hidden" Text='<%# Eval("id") %>'></asp:TextBox>
                    </td>
                    <td>
                        <%# Eval("Email")%>
                    </td>
                    <td style="text-align:left; padding-left:5px;">
                        <a href='Send_Show.aspx?id=<%# Eval("id") %>'><%# Eval("Title")%></a>
                    </td>                    
                    <td>
                        <%#Eval("PubDate") %>
                    </td>
                    <td>
                        <asp:LinkButton ID="LinkButton1" OnLoad="Delete_Load" runat="server" CommandName="deleteobj"
                            CommandArgument='<%# Eval("id") %>'>删除</asp:LinkButton>
                    </td>
                </tr>
            </ItemTemplate>
            <EmptyDataTemplate>
                <table cellpadding="0" cellspacing="1" border="0" width="100%" class="border">
                    <tr class="suphead">
                        <td>
                           暂时没有数据
                        </td>
                    </tr>
                </table>
            </EmptyDataTemplate>
        </asp:ListView>
        <div align="center">
            <asp:Button ID="BtnSelect" runat="server" Text="全选" OnClick="BtnSelect_Click" />
            <asp:DropDownList ID="BatRunType" runat="server">
                <asp:ListItem Text="批量删除" Value="delete"></asp:ListItem>
            </asp:DropDownList>
            <asp:Button ID="BtnRun" runat="server" Text="执行操作" OnClick="BtnRun_Click" OnClientClick="return confirm('确定执行吗?')" />
        </div>
        <cc1:Pager ID="Pager1" runat="server" GenerateFirstLastSection="True" 
      GenerateGoToSection="True" GenerateHiddenHyperlinks="False" 
      QueryStringParameterName="CurrentPage" OnCommand="pager_Command" 
      GoToStyle="text" OfClause="/" PageClause="页" PageSize="15" />
    </div>
    </form>
</body>
</html>
