﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Staff_Archives.aspx.cs" Inherits="TotCms.Web.Office.Staff.Staff_Archives" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link href="../style/global.css" rel="stylesheet" type="text/css" />
    <link href="../../js/jquery-ui-1.8.10/css/ui-lightness/jquery-ui-1.8.10.custom.css" rel="stylesheet" type="text/css" />
  <script src="../../js/jquery-1.5.1.min.js" type="text/javascript"></script>
  <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.core.min.js" type="text/javascript"></script>
  <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.widget.min.js" type="text/javascript"></script>
  <script src="../../js/jquery-ui-1.8.10/js/jquery.ui.datepicker.min.js" type="text/javascript"></script>
  <script src="../../js/jquery-ui-1.8.10/js/i18n/jquery.ui.datepicker-zh-CN.js" type="text/javascript"></script>
  <script type="text/javascript">
    $(function () {
      $('.dates').datepicker($.datepicker.regional["zh-CN"]);
    });
  </script>
</head>
<body>
    <form id="form1" runat="server">    
    <asp:ListView ID="lvList" runat="server" ItemPlaceholderID="items" InsertItemPosition="LastItem" 
        onselectedindexchanged="lvList_SelectedIndexChanged" 
        onitemdeleting="lvList_ItemDeleting" onitemediting="lvList_ItemEditing" 
        oniteminserting="lvList_ItemInserting" 
        onitemupdating="lvList_ItemUpdating" onitemcommand="lvList_ItemCommand" 
        onitemcanceling="lvList_ItemCanceling" 
      onitemdatabound="lvList_ItemDataBound" DataKeyNames="id">
        <LayoutTemplate>
          <table cellpadding="0" cellspacing="1" border="0" width="100%" class="border">            
          <tr class="suphead">
              <td>标题</td>
              <td>原因</td>
              <td>日期</td>
              <td>操作</td>
          </tr>
          <asp:PlaceHolder runat="server" ID="items"></asp:PlaceHolder>
          </table>
        </LayoutTemplate>
        <EditItemTemplate>
            <tr class="lines">
            <td><asp:TextBox ID="tbTitle" runat="server" Text='<%# Eval("Title") %>'></asp:TextBox></td>
            <td><asp:TextBox ID="tbReason" runat="server" Text='<%# Eval("Reason") %>'></asp:TextBox></td>
            <td><asp:TextBox ID="tbPubDate" runat="server" Text='<%# FormatDate(Eval("PubDate")) %>' CssClass="dates"></asp:TextBox></td>            
            <td>
              <asp:Button ID="UpdateButton" runat="server" CommandName="Update" 
                    Text="完成" />
                <asp:Button ID="CancelButton" runat="server" CommandName="Cancel" 
                    Text="取消" />
            </td>
            </tr>
            <tr class="contentlines">
              <td colspan="6">备注：<asp:TextBox ID="tbContent" runat="server" Text='<%# Eval("Content") %>' TextMode="MultiLine" CssClass="text_normal"></asp:TextBox></td>
            </tr>
        </EditItemTemplate>
        <EmptyDataTemplate>
            暂时没有数据.
        </EmptyDataTemplate>
        <InsertItemTemplate>
            <tr class="alterlines">
            <td><asp:TextBox ID="tbTitle" runat="server"></asp:TextBox></td>
            <td><asp:TextBox ID="tbReason" runat="server"></asp:TextBox></td>
            <td><asp:TextBox ID="tbPubDate" runat="server" CssClass="dates"></asp:TextBox></td>           
            <td>
            <asp:Button ID="InsertButton" runat="server" CommandName="Insert" 
                    Text="添加" />
                <asp:Button ID="CancelButton" runat="server" CommandName="Cancel" 
                    Text="取消" />
            </td>
            </tr>
            <tr class="contentlines">
              <td colspan="6">备注：<asp:TextBox ID="tbContent" runat="server" TextMode="MultiLine" CssClass="text_normal"></asp:TextBox></td>
            </tr>
        </InsertItemTemplate>

        <ItemTemplate>
            <tr class="lines">
            <td><%# Eval("Title")%></td>
            <td><%# Eval("Reason")%></td>
            <td><%# FormatDate(Eval("PubDate"))%></td>           
            <td>
            <asp:Button ID="EditButton" runat="server" CommandName="Edit" Text="编辑" />
                    <asp:Button ID="DeleteButton" runat="server" CommandName="Delete" 
                        Text="删除" OnClientClick="return confirm('确定删除吗?')" />
            </td>
            </tr>
            <tr class="contentlines">
              <td colspan="6">备注：<%# Eval("Content") %></td>
            </tr>
        </ItemTemplate>
        
    </asp:ListView>
    </form>
</body>
</html>
