﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Admin/AdminMain.Master" Inherits="System.Web.Mvc.ViewPage" %>

<asp:Content ID="Content0" ContentPlaceHolderID="HeadContent" runat="server">
	<style type="text/css">
		#step2box, #step3box
		{
			display: none;
		}
		#content
		{
			width: 100%;
			height: 300px;
		}
	</style>
	<script src="../../Scripts/jquery-1.3.2.min.js" type="text/javascript"></script>
	<script type="text/javascript">
		$.ajaxSetup({ cache: false });

		$(document.body).ready(function () {
			$("#step1btn").attr("disabled", "disabled");
			$.post('<%= Url.Action("CSVGetOptionString") %>', null, function (data) {
				if (data.success) {
					$("#step1opt").html(data.message);
					$("#step1btn").removeAttr("disabled");
				}
				else {
					alert(data.message);
				}
			}, "json");

			$("#step1btn").click(function () {
				if ($("#step1opt")[0].selectedIndex == 0) {
					alert("必须选择一个表格。");
					$("#step1opt").focus();
					return;
				}
				$("#step2opt").text("加载中...");
				$.post('<%= Url.Action("GetFields") %>', { name: $("#step1opt").val() }, function (data) {
					$("#step2opt").html(data);
				});
				$("#step2box").slideDown();
			});
			$("#step2btn").click(function () {
				var jqfields = $(":checkbox:checked");
				if (jqfields.length == 0) {
					alert("至少需要选择一个字段。");
					return;
				}
				$("#content").text("加载中...");
				$.post('<%= Url.Action("CSVGenerateTML") %>', $("#form1").serialize(), function (data) {
					$("#content").text(data);
				});
				$("#step3box").slideDown();
			});
			$("#content").click(function () {
				this.select();
				return false;
			});
		});
	</script>
</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	查询模块生成
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
	<fieldset style="margin: 0; padding: 0">
		<legend>Excel文件查询模块生成说明</legend>
		<ol style="line-height: 150%">
			<li>首先将Excel文件保存为csv格式并上传到/App_Data/CSV目录中；</li>
			<li>再使用本工具生成代码。</li>
		</ol>
	</fieldset>
	<form method="post" id="form1" action="<%= Url.Action("CSVCreateTML") %>">
	<fieldset id="step1box">
		<legend>第一步：选择待查询表格</legend>
		<select id="step1opt" name="filename">
			<option>加载中...</option>
		</select>
		<input type="button" value="下一步" id="step1btn" />
	</fieldset>
	<fieldset id="step2box">
		<legend>第二步：选择可查询字段</legend>
		<div id="step2opt">
		</div>
		<input type="button" value="下一步" id="step2btn" />
	</fieldset>
	</form>
	<form id="form2" action="<%= Url.Action("ModuleEdit") %>" method="post">
		<fieldset id="step3box">
			<legend>第三步：预览代码</legend>
			<textarea rows="5" cols="60" id="content" name="content" readonly="readonly"></textarea>
			<p><input type="submit" value="下一步" /></p>
		</fieldset>
	</form>
</asp:Content>

