﻿<%@ WebHandler Language="C#" Class="CommHandler" %>

using System;
using System.Web;

using System.Web.SessionState;

using DJG.Common;
using DJG.International;

public class CommHandler : IHttpHandler, IRequiresSessionState{
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        context.Response.Expires = 0;

        string act = PublicClass.GetQueryString(context, "act");
        string resourceName = PublicClass.GetQueryString(context, "rn");

        switch (act.ToLower())
        {
            case "int":
                GetResourceValue(resourceName, context);
                break;
        }
    }

    public void GetResourceValue(string resourceName, HttpContext context)
    {
        if (!string.IsNullOrEmpty(resourceName))
            context.Response.Write(ResourceManager.GetString(resourceName));
        else
            context.Response.Write("");
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}