﻿<%@ WebHandler Language="C#" Class="NewsHandler" %>

using System;
using System.Web;
using System.Data;

using System.Web.SessionState;

using DJG.Bll;
using DJG.Common;
using DJG.DALOleDbServer;
using DJG.Model;
using DJG.International;

public class NewsHandler : IHttpHandler, IRequiresSessionState{
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        context.Response.Expires = 0;

        string id = PublicClass.GetQueryString(context, "id");
        string num = PublicClass.GetQueryString(context, "num");
        string act = PublicClass.GetQueryString(context, "act");

        switch (act.ToLower())
        {
            case "getnum"://获取点击数
                GetClickNumber(id, context);
                break;
            case "pre":
                GetPrevious(id, context);
                break;
            case "next":
                GetNext(id, context);
                break;
        }

    }

    public void GetClickNumber(string id, HttpContext context)
    {
        try
        {
            NewsBll bll = new NewsBll();
            NewsModel model = new NewsModel();
            NewsObj.FileterSql filter = new NewsObj.FileterSql();
            filter.model.Id = id;
            DBFilters.IFilter = filter;
            model = bll.GetInfo(NewsBll.SQL_QUERY_CLICKNUMBER);
            if (model != null)
            {
                string num = Convert.ToString(int.Parse(model.ClickNumber) + 1);
                
                model.ClickNumber = num;

                #region 更新点击
                filter = new NewsObj.FileterSql();
                filter.model.Id = id;
                DBFilters.IFilter = filter;
                if (bll.Update(model, NewsBll.SQL_UPDATE_NUMBER) > 0)
                    context.Response.Write(num);
                else
                    context.Response.Write(model.ClickNumber);
                #endregion
                
            }
            else
            {
                context.Response.Write("0");
            }
        }
        catch (Exception ex)
        {
            LogClass.Add(LogClass.LogType.Error, ex.ToString(), NewsBll.SQL_UPDATE);
            context.Response.Write("0");
        }
    }

    public void GetPrevious(string id, HttpContext context)
    {
        try
        {
            NewsBll bll = new NewsBll();
            NewsModel model = new NewsModel();
            NewsObj.FileterSql filter = new NewsObj.FileterSql();
            filter.IDPre = id;
            filter.OrderByField = new string[] { NewsModel.fId };
            filter.OrderBySort = EnumClass.OrderByEnum.DESC.ToString();
            DBFilters.IFilter = filter;
            DataTable dt = bll.GetList(string.Format(NewsBll.SQL_TOP_QUERY, 1));
            if (dt != null && dt.Rows.Count > 0)
                context.Response.Write("<a href=\"NewsView.aspx?id=" + dt.Rows[0][NewsModel.fId].ToString() + "\">" + dt.Rows[0][UserLanguage.GetIntField(NewsModel.fNewsName)].ToString() + "</a>");
            else
                context.Response.Write(ResourceManager.GetString("Common_Label_Pre_Nothing_Title"));

        }
        catch (Exception ex)
        {
            LogClass.Add(LogClass.LogType.Error, ex.ToString(), NewsBll.SQL_TOP_QUERY);
            context.Response.Write(ResourceManager.GetString("Common_Msg_Data_ReadFaied"));
        }
    }

    public void GetNext(string id, HttpContext context)
    {
        try
        {
            NewsBll bll = new NewsBll();
            NewsModel model = new NewsModel();
            NewsObj.FileterSql filter = new NewsObj.FileterSql();
            filter.IDNext = id;
            filter.OrderByField = new string[] { NewsModel.fId };
            filter.OrderBySort = EnumClass.OrderByEnum.ASC.ToString();
            DBFilters.IFilter = filter;
            DataTable dt = bll.GetList(string.Format(NewsBll.SQL_TOP_QUERY, 1));
            if (dt != null && dt.Rows.Count > 0)
                context.Response.Write("<a href=\"NewsView.aspx?id=" + dt.Rows[0][NewsModel.fId].ToString() + "\">" + dt.Rows[0][UserLanguage.GetIntField(NewsModel.fNewsName)].ToString() + "</a>");
            else
                context.Response.Write(ResourceManager.GetString("Common_Label_Next_Nothing_Title"));
        }
        catch (Exception ex)
        {
            LogClass.Add(LogClass.LogType.Error, ex.ToString(), NewsBll.SQL_TOP_QUERY);
            context.Response.Write(ResourceManager.GetString("Common_Msg_Data_ReadFaied"));
        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}