﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using DAL;
using System.Data;
namespace BLL
{
   public class BaseBLL
    {
       public object CreateObject(Type t, Dictionary<string, string> dic)
       {
           object obj = Activator.CreateInstance(t);
           foreach (PropertyInfo pi in t.GetProperties())
           {
               if (dic.ContainsKey(pi.Name))
               {
                   pi.SetValue(obj, dic[pi.Name], null);
               }
           }
           return obj;
       }
       public int SaveObject(object obj, string tableName)
       {
           Type t = obj.GetType();
           string Cloumns = "";
           string value="";
           foreach (PropertyInfo pi in t.GetProperties())
           {
               if (pi.GetValue(obj, null)!=null)
               {
                   Cloumns = Cloumns + pi.Name + ",";
                   value = value + "'" + pi.GetValue(obj, null).ToString() + "',";
               }
           }
           Cloumns = Cloumns.Substring(0, Cloumns.Length - 1);
           value = value.Substring(0, value.Length - 1);
           DBHelper.Parameter[] par = {
                                          new DBHelper.Parameter("@TableName",DbType.String,50,ParameterDirection.Input,tableName),
                                          new DBHelper.Parameter("@Clomns",DbType.String,200,ParameterDirection.Input,Cloumns),
                                            new DBHelper.Parameter("@Value",DbType.String,300,ParameterDirection.Input,value)
                                      };
           DBHelper.OutputParameter outputpar=null;
          return DBHelper.ExecuteStoredProcedureNonQuery("pro_Insert", ref outputpar, par);
       }
       public int UpdateObject(object obj, string tableName, string Conditoon)
       {
           Type t = obj.GetType();
           string SetValue="";
           foreach (PropertyInfo pi in t.GetProperties())
           {
               if (pi.GetValue(obj, null) != null)
               {
                   SetValue = SetValue + pi.Name + "='" + pi.GetValue(obj, null).ToString() + "',";
               }
           }
           SetValue = SetValue.Substring(0, SetValue.Length - 1);
           DBHelper.OutputParameter OutPara=null;
           DBHelper.Parameter[] para={
                                         new DBHelper.Parameter("@TableName",DbType.String,50,ParameterDirection.Input,tableName),
                                         new DBHelper.Parameter("@SetValue",DbType.String,200,ParameterDirection.Input,SetValue),
                                         new DBHelper.Parameter("@Condition",DbType.String,100,ParameterDirection.Input,Conditoon)
                                         
                                     };
           return DBHelper.ExecuteStoredProcedureNonQuery("pro_Update", ref OutPara, para);
       }
       public int Delete0bject(string tableName, string Condition)
       {
           DBHelper.OutputParameter Outpara = null;
           DBHelper.Parameter[] para ={
                                          new DBHelper.Parameter("@TableName",DbType.String,50,ParameterDirection.Input,tableName),
                                          new DBHelper.Parameter("@Condition",DbType.String,200,ParameterDirection.Input,Condition)
                                      };
           return DBHelper.ExecuteStoredProcedureNonQuery("Pro_Delete", ref Outpara, para);
       }
       public List<object> SelectObject(Type t, string TaleName, string Cloumns, string Condition)
       {
           List<object> list = new List<object>();
           DBHelper.OutputParameter Outpara = null;
           DBHelper.Parameter[] pare = {
                                           new DBHelper.Parameter("@TableName",DbType.String,50,ParameterDirection.Input,TaleName),
                                           new DBHelper.Parameter("@Cloumns",DbType.String,200,ParameterDirection.Input,Cloumns),
                                           new DBHelper.Parameter("@Condition",DbType.String,100,ParameterDirection.Input,Condition) 
                                       };
           DataTable dt = DBHelper.ExecuteStoredProcedureWithQuery("pro_select", ref Outpara, pare).Tables[0];
           if (dt.Rows.Count > 0)
           {
               for (int i = 0; i < dt.Rows.Count; i++)
               {
                   object obj = Activator.CreateInstance(t);
                   foreach (PropertyInfo pi in t.GetProperties())
                   {
                       if (dt.Columns.Contains(pi.Name))
                       {
                           pi.SetValue(obj, dt.Rows[i][pi.Name].ToString(), null);
                       }
                   }
                   list.Add(obj);
               }
           }
           return list;
       }
       public int CheckLogin(string sql,string username,string password)
       {
           DBHelper.Parameter[] pare={
                                       new DBHelper.Parameter("@UserName",DbType.String,50,ParameterDirection.Input,username),
                                       new DBHelper.Parameter("@PassWord",DbType.String,50,ParameterDirection.Input,password)
                                     };
           return Convert.ToInt32(DBHelper.ExecuteScalar(sql,pare));
       }
       public List<object> SelctObjectByPage(Type t, string TableName, string Cloumns, string Condition, int PageIndex, int PageCount, string PK, string Order)
       {
           List<object> list = new List<object>();
           DBHelper.OutputParameter Outpare = null;
           DBHelper.Parameter[] pare ={
                                          new DBHelper.Parameter("@TableName",DbType.String,50,ParameterDirection.Input,TableName),
                                          new DBHelper.Parameter("@Cloumns",DbType.String,100,ParameterDirection.Input,Cloumns),
                                          new DBHelper.Parameter("@Contidion",DbType.String,100,ParameterDirection.Input,Condition),
                                          new DBHelper.Parameter("@Pageindex",DbType.Int32,4,ParameterDirection.Input,PageIndex),
                                          new DBHelper.Parameter("@Pagecount",DbType.Int32,4,ParameterDirection.Input,PageCount),
                                          new DBHelper.Parameter("@PK",DbType.String,50,ParameterDirection.Input,PK),
                                          new DBHelper.Parameter("@Order",DbType.String,50,ParameterDirection.Input,Order)
                                         
                                     };
           DataTable dt = DBHelper.ExecuteStoredProcedureWithQuery("proc_SelByPage", ref Outpare, pare).Tables[0];
           if (dt.Rows.Count > 0)
           {
               for (int i = 0; i < dt.Rows.Count; i++)
               {
                   object obj = Activator.CreateInstance(t);
                   foreach (PropertyInfo pi in t.GetProperties())
                   {
                       if(dt.Columns.Contains(pi.Name))
                       {
                         pi.SetValue(obj, dt.Rows[i][pi.Name].ToString(), null);
                       }
                   }
                   list.Add(obj);
               }
           }
           return list;
       }
       public int SelPageCount(string TableName,string Condition,int pagecount)
       {
           DBHelper.OutputParameter Outpara = null;
           DBHelper.Parameter[] pare = {
                                           new DBHelper.Parameter("@TableName",DbType.String,50,ParameterDirection.Input,TableName),
                                           new DBHelper.Parameter("@Condition",DbType.String,100,ParameterDirection.Input,Condition) 
                                       };
          int i=Convert.ToInt32( DBHelper.ExecuteStoredProcedureWithQuery("pro_SelCount", ref Outpara, pare).Tables[0].Rows[0][0].ToString());
          if (i % pagecount == 0)
          {
              return i / pagecount;
          }
          else
          {
              return i / pagecount + 1;
          }
           
           
       }
       public int AduitUserLeave(int ID, int UserID)
       {
           DBHelper.OutputParameter outpara = new DBHelper.OutputParameter();
           DBHelper.Parameter[] para ={
                                         new DBHelper.Parameter("@ID",DbType.Int32,4,ParameterDirection.Input,ID),
                                         new DBHelper.Parameter("@UserID",DbType.Int32,4,ParameterDirection.Input,UserID),
                                         new DBHelper.Parameter("@result",DbType.Int32,4,ParameterDirection.Output,null)
                                     };
           DBHelper.ExecuteStoredProcedureNonQuery("proc_foruserleave", ref outpara, para);
           return Convert.ToInt32(outpara["result"].ToString());
       }

    }
}
