﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Model;
using BLL;
using System.Data;
namespace ComResProSystem
{
    public partial class UserSelect:BasePage
    {
        BaseBLL bll = new BaseBLL();
        UserBll usebll = new UserBll();
        protected void Page_Load(object sender, EventArgs e)
        {
            if(!IsPostBack)
            {
                BindPart();
                BindPos();
                BindUser(1);
                PageCount(3);
                setEnable();
            }
        }
        protected void BindPart()
        {
            DataTable dt = usebll.gettable("SELECT DISTINCT Part FROM Users");
            Dd_Part.DataSource = dt;
            Dd_Part.DataTextField = "Part";
            Dd_Part.DataValueField = "Part";
            Dd_Part.DataBind();
            Dd_Part.Items.Add(new ListItem("-请选择-", "-请选择-"));
            Dd_Part.SelectedValue = "-请选择-";
        }
        protected void BindPos()
        {
            DataTable dt = usebll.gettable("SELECT DISTINCT UserPos FROM Users");
            Dd_UserPos.DataSource = dt;
            Dd_UserPos.DataTextField = "UserPos";
            Dd_UserPos.DataValueField = "UserPos";
            Dd_UserPos.DataBind();
            Dd_UserPos.Items.Add(new ListItem("-请选择-", "-请选择-"));
            Dd_UserPos.SelectedValue = "-请选择-";
        }
        protected void Ibt_select_Click(object sender, ImageClickEventArgs e)
        {
            BindUser(1);
            PageCount(3);
            setEnable();
        }
        protected void BindUser(int pageindex)
        {
            List<object> list = bll.SelctObjectByPage(typeof(Model.User), "Users", "ID,UserName,Part,UserPos", Condition(), pageindex, 3, "ID", "ID");
            Rp_User.DataSource = list;
            Rp_User.DataBind();
            if (list.Count > 0)
            {
                Div.Attributes.Add("style", "margin-right: 5%;");
            }
            else
            {
                Div.Attributes.Add("style", "margin-right: 5%;display:none");
            }

        }
        public void PageCount(int Page)
        {
            Lb_Total.Text = bll.SelPageCount("Users", Condition(), Page).ToString();
            Lb_Now.Text = "1";
        }
        public void setEnable()
        {
            Ibt_Firsr.Enabled = Lb_Now.Text == "1" ? false : true;
            Ibt_Pre.Enabled = Lb_Now.Text == "1" ? false : true; ;
            Ibt_Next.Enabled = Lb_Now.Text == Lb_Total.Text ? false : true;
            Ibt_Last.Enabled = Lb_Now.Text == Lb_Total.Text ? false : true;
        }
        protected string Condition()
        {
            string condition = "1=1";
            if (Dd_Part.Text != "-请选择-")
            {
                condition = condition + " and Part='" + Dd_Part.Text + "'";
            }
            if (Dd_UserPos.Text != "-请选择-")
            {
                condition = condition + " and UserPos='" + Dd_UserPos.Text + "'";
            }
            if (Tb_UserName.Text != "")
            {
                condition = condition + " and UserName='" + Tb_UserName.Text + "'";
            }
            return condition;
        }

        protected void Ibt_Firsr_Click(object sender, ImageClickEventArgs e)
        {
            BindUser(1);
            Lb_Now.Text = "1";
            setEnable();
        }

        protected void Ibt_Pre_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Now.Text) - 1;
            BindUser(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_Next_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Now.Text)+1;
            BindUser(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_Last_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Total.Text);
            BindUser(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_goto_Click(object sender, ImageClickEventArgs e)
        {
            if (Tb_goto.Text != "")
            {
                int go = Convert.ToInt32(Tb_goto.Text);
                int total = Convert.ToInt32(Lb_Total.Text);
                if (go >= 1 && go <= total)
                {
                    BindUser(go);
                    Lb_Now.Text = go.ToString();
                    setEnable();
                    Tb_goto.Text = "";
                }
                else
                {
                    Tb_goto.Text = "";
                }
            }
        }
    }
}