﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Model;
using BLL;
namespace ComResProSystem
{
    public partial class WorkPlan :BasePage
    {
        BaseBLL bll = new BaseBLL();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindPlan(1);
                PageCount(3);
                setEnable();
            }
        }

        protected void Lb_PlanAdd_Click(object sender, EventArgs e)
        {
           
            if (DateTime.Now.DayOfWeek == DayOfWeek.Monday)
            {
                Response.Redirect("AddWorkPlan.aspx");
            }
            else
            {
                ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "alert('请在周一填写工作总结!')", true);

            }
        }

        protected void Ibt_Select_Click(object sender, ImageClickEventArgs e)
        {
            BindPlan(1);
            PageCount(3);
            setEnable();
        }
        protected void BindPlan(int pageindex)
        {
            if (Condition() != "")
            {
                List<object> list = bll.SelctObjectByPage(typeof(Model.WorkPlan), "WorkPlan", "ID,Theme,Contents,AddUser,AddTime ", Condition(), pageindex, 3, "ID", "ID");
                Rp_Plan.DataSource = list;
                Rp_Plan.DataBind();
                if (list.Count > 0)
                {
                    div.Attributes.Add("style", "width:80%;margin:0px auto;");
                }
                else
                {
                    div.Attributes.Add("style", "width:80%;margin:0px auto;display:none");
                }
            }
            else
            {
                ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "alert('改员工没有下属！')", true);
            }
        }
        protected string Condition()
        {
            string condition = "";
            if (Dd_ProType.Text == "个人工作总结")
            {
                condition = "AddUser='" + Session["UserName"].ToString() + "'";
            }
            if (Dd_ProType.Text == "下属工作总结")
            {
                if (Session["UserName"].ToString() == "admin")
                {
                    List<object> listName = bll.SelectObject(typeof(Model.User), "Users", "UserName", "UserPos='部门主管'");
                    for (int i = 0; i < listName.Count; i++)
                    {
                        Model.User username = (Model.User)listName[i];
                        condition = condition + "'" + username.UserName + "',";
                    }
                    condition = condition.Substring(0, condition.Length - 1);
                    condition = "AddUser in (" + condition + ")";
                }
                else
                {
                    List<object> list = bll.SelectObject(typeof(Model.User), "Users", "UserPos,Part", "UserName='" + Session["UserName"].ToString() + "'");
                    Model.User user = (Model.User)list[0];
                    if (user.UserPos == "部门主管")
                    {
                        List<object> listName = bll.SelectObject(typeof(Model.User), "Users", "UserName", "Part='" + user.Part + "' and UserPos='普通员工'");
                        for (int i = 0; i < listName.Count; i++)
                        {
                            Model.User username = (Model.User)listName[i];
                            condition = condition + "'" + username.UserName + "',";
                        }
                        condition = condition.Substring(0, condition.Length - 1);
                        condition = "AddUser in (" + condition + ")";

                    }
                }
               
            }
            return condition;
        }
        public void setEnable()
        {
            Ibt_Firsr.Enabled = Lb_Now.Text == "1" ? false : true;
            Ibt_Pre.Enabled = Lb_Now.Text == "1" ? false : true; ;
            Ibt_Next.Enabled = Lb_Now.Text == Lb_Total.Text ? false : true;
            Ibt_Last.Enabled = Lb_Now.Text == Lb_Total.Text ? false : true;
        }
        public void PageCount(int Page)
        {
            if (Condition() != "")
            {
                Lb_Total.Text = bll.SelPageCount("WorkPlan", Condition(), Page).ToString();
                Lb_Now.Text = "1";
            }
           
        }

        protected void Ibt_Firsr_Click(object sender, ImageClickEventArgs e)
        {
            BindPlan(1);
            Lb_Now.Text = "1";
            setEnable();

        }

        protected void Ibt_Pre_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Now.Text) - 1;
            BindPlan(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_Next_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Now.Text) + 1;
            BindPlan(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_Last_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Total.Text);
            BindPlan(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_goto_Click(object sender, ImageClickEventArgs e)
        {
            if (Tb_goto.Text != "")
            {
                int go = Convert.ToInt32(Tb_goto.Text);
                int total = Convert.ToInt32(Lb_Total.Text);
                if (go >= 1 && go <= total)
                {
                    BindPlan(go);
                     Lb_Now.Text = go.ToString();
                    setEnable();
                    Tb_goto.Text = "";
                }
                else
                {
                    Tb_goto.Text = "";
                }
            }
        }

        protected void Lb_Del_Click(object sender, EventArgs e)
        {
            string ID = "";
            foreach (RepeaterItem item in Rp_Plan.Items)
            {
                CheckBox ck = (CheckBox)item.FindControl("Ck_Check");
                if (ck.Checked)
                {
                    Label lb = (Label)item.FindControl("Lb_ID");
                    ID = ID + lb.Text+",";
                }
            }
            ID=ID.Substring(0,ID.Length-1);
            if (bll.Delete0bject("WorkPlan", "ID in(" + ID + ")") == 0)
            {
                ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "alert('删除成功！')", true);
                BindPlan(1);
                PageCount(3);
                setEnable();
            }
            else
            {
                ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "alert('删除失败！')", true);
               
            }
        }
    }
}