﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Model;
using BLL;
namespace ComResProSystem
{
    public partial class WorkPro:BasePage
    {
        BaseBLL bll = new BaseBLL();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindRpWorkpro(1);
                PageCount(3);
                setEnable();
            }
        }

        protected void Lb_ProAdd_Click(object sender, EventArgs e)
        {
            if (DateTime.Now.DayOfWeek == DayOfWeek.Monday)
            {
                Response.Redirect("AddWorkPro.aspx");
            }
            else
            {
                ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "alert('请在周一填写工作计划!')", true);

            }
        }

        protected void ImageButton1_Click(object sender, ImageClickEventArgs e)
        {
            BindRpWorkpro(1);
            PageCount(3);
            setEnable();
        }
        protected void BindRpWorkpro(int pageindex)
        {
            if (Condition() != "")
            {
                List<object> list = bll.SelctObjectByPage(typeof(Model.WorkPro), "WorkPro", "ID,Theme,AddUser,Contents,AddTime", Condition(), pageindex, 3, "ID", "ID");
                Rp_Pro.DataSource = list;
                Rp_Pro.DataBind();
                if (list.Count > 0)
                {
                    div.Attributes.Add("style", "width:80%;margin:0px auto;");
                }
                else
                {
                    div.Attributes.Add("style", "width:80%;margin:0px auto;display:none");
                }
            }
            else
            {
                ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "alert('当前用户不存在下属!')", true);
              
            }
        }
        public void PageCount(int Page)
        {
            if (Condition() != "")
            {
                Lb_Total.Text = bll.SelPageCount("WorkPro", Condition(), Page).ToString();
                Lb_Now.Text = "1";
            }
        }
        protected string Condition()
        {
            string str = "";
            if (Dd_ProType.Text == "个人工作计划")
            {
                str = "AddUser='" + Session["UserName"].ToString() + "'";
            }
            if (Dd_ProType.Text == "下属工作计划")
            {
                if (Session["UserName"].ToString() == "admin")
                {
                    List<object> listName = bll.SelectObject(typeof(Model.User), "Users", "UserName", "UserPos='部门主管'");
                    for (int i = 0; i < listName.Count; i++)
                    {
                        Model.User username = (Model.User)listName[i];
                        str = str + "'" + username.UserName + "',";
                    }
                    str = str.Substring(0, str.Length - 1);
                    str = "AddUser in (" + str + ")";
                }
                else
                {
                    List<object> list = bll.SelectObject(typeof(Model.User), "Users", "UserPos,Part", "UserName='" + Session["UserName"].ToString() + "'");
                    Model.User user = (Model.User)list[0];
                    if (user.UserPos == "部门主管")
                    {
                        List<object> listName = bll.SelectObject(typeof(Model.User), "Users", "UserName", "Part='" + user.Part + "' and UserPos='普通员工'");
                        for (int i = 0; i < listName.Count; i++)
                        {
                            Model.User username = (Model.User)listName[i];
                            str = str + "'" + username.UserName + "',";
                        }
                        str = str.Substring(0, str.Length - 1);
                        str = "AddUser in (" + str + ")";
                    }
                }
            }
            return str;
        }
        public void setEnable()
        {
            Ibt_Firsr.Enabled = Lb_Now.Text == "1" ? false : true;
            Ibt_Pre.Enabled = Lb_Now.Text == "1" ? false : true; ;
            Ibt_Next.Enabled = Lb_Now.Text == Lb_Total.Text ? false : true;
            Ibt_Last.Enabled = Lb_Now.Text == Lb_Total.Text ? false : true;
        }

        protected void Ibt_Firsr_Click(object sender, ImageClickEventArgs e)
        {
            BindRpWorkpro(1);
            Lb_Now.Text = "1";
            setEnable();
        }

        protected void Ibt_Pre_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Now.Text) - 1;
            BindRpWorkpro(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_Next_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Now.Text) +1;
            BindRpWorkpro(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_Last_Click(object sender, ImageClickEventArgs e)
        {
            int pageindex = Convert.ToInt32(Lb_Total.Text);
            BindRpWorkpro(pageindex);
            Lb_Now.Text = pageindex.ToString();
            setEnable();
        }

        protected void Ibt_goto_Click(object sender, ImageClickEventArgs e)
        {
            if (Tb_goto.Text != "")
            {
                int go = Convert.ToInt32(Tb_goto.Text);
                int total = Convert.ToInt32(Lb_Total.Text);
                if (go >= 1 && go <= total)
                {
                    BindRpWorkpro(go);
                    Lb_Now.Text = go.ToString();
                    setEnable();
                    Tb_goto.Text = "";
                }
                else
                {
                    Tb_goto.Text = "";
                }
            }
        }

        protected void Lb_Del_Click(object sender, EventArgs e)
        {
            string ID = "";
            foreach (RepeaterItem item in Rp_Pro.Items)
            {
                CheckBox ck = (CheckBox)item.FindControl("Ck_Check");
                if (ck.Checked)
                {
                    Label Lb = (Label)item.FindControl("Lb_ID");
                    ID = ID + Lb.Text + ",";
                }
            }
            ID = ID.Substring(0, ID.Length - 1);
            if (bll.Delete0bject("WorkPro", "ID in (" + ID + ")") == 0)
            {
                ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "alert('删除成功!')", true);
                BindRpWorkpro(1);
                Lb_Now.Text = "1";
                setEnable();
            }
            else
            {
                ClientScript.RegisterClientScriptBlock(this.GetType(), "alert", "alert('删除失败!')", true);

            }
        }

    }
}