﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.BLL.SiteBLL
{
    [Serializable]
    public class WebLM:BaseBLL
    {
        private KstCMS.DAL.IWebLM ILm;

        public WebLM()
        {
            if (DBType == "1")
                ILm = new KstCMS.DAL.OleDB.WebLM();
            //else  //SQL数据库
            //    ILm = new KstCMS.DAL.SqlDB.WebLM();
        }

        public void Add(string[] FieldValues, params string[] FieldNames)
        {
            string SiteId = "", MenuId = "", HtmlFile = "";
            for (int i = 0; i < FieldNames.Length; i++)
            {
                if (FieldNames[i] == "SiteID")
                    SiteId = FieldValues[i].ToString();
                if (FieldNames[i] == "MenuID")
                    MenuId = FieldValues[i].ToString();
                if (FieldNames[i] == "uPageFile")
                    HtmlFile = FieldValues[i].ToString();
            }
            if (ILm.Exists(int.Parse(SiteId), int.Parse(MenuId), HtmlFile))
                throw new Exception("栏目文件已存在，请重新输入！");

            ILm.Add(FieldValues, FieldNames);
        }

        public void Update(string[] FieldValues, int LmId, params string[] FieldNames)
        {
            ILm.Update(FieldValues, LmId, FieldNames);
        }

        public void Delete(int LmId)
        {
            ILm.Delete(LmId);
        }

        public KstCMS.Model.SiteModel.WebLM GetModel(int LmId, params string[] FieldNames)
        {
            return ILm.GetModel(LmId, FieldNames);
        }

        public System.Data.DataSet Get_List(int SiteId, int MenuId, int Act, params string[] FieldNames)
        {
            System.Data.DataSet dsData = null;
            switch (Act)
            {
                case -1:
                    dsData = ILm.GetList(string.Format("SiteID={0} and MenuID={1}", SiteId.ToString(), MenuId.ToString()), "SortNo asc", 0, FieldNames);
                    break;
                case 0:
                    dsData = ILm.GetList(string.Format("SiteID={0} and MenuID={1} and Act=0", SiteId.ToString(), MenuId.ToString()), "SortNo asc", 0, FieldNames);
                    break;
                case 1:
                    dsData = ILm.GetList(string.Format("SiteID={0} and MenuID={1} and Act=1", SiteId.ToString(), MenuId.ToString()), "SortNo asc", 0, FieldNames);
                    break;
            }
            return dsData;
        }

        public bool Exists(int LmId)
        {
            return ILm.Exists(LmId);
        }

        public bool Exists(int SiteId, int MenuId, string HtmlFile)
        {
            return ILm.Exists(SiteId, MenuId, HtmlFile);
        }



    }
}
