﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.DAL.OleDB
{
    public class AdminRole:IRole
    {
        public int Add(KstCMS.Model.SiteModel.AdminRole Model)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Role(RoleName,RunCode) values(@RoleName,@RunCode)");
            System.Data.OleDb.OleDbParameter[] cmdPams = new System.Data.OleDb.OleDbParameter[]
            {
                new System.Data.OleDb.OleDbParameter("@RoleName",System.Data.OleDb.OleDbType.VarChar,50),
                 new System.Data.OleDb.OleDbParameter("@RunCode",System.Data.OleDb.OleDbType.LongVarChar)
            };
            cmdPams[0].Value = Model.RoleName;
            cmdPams[1].Value = Model.RunCode;
            object single = KstSoft.DBUtility.OleDB_Helper.GetSingle(sb.ToString(), cmdPams);
            if (single == null)
            {
                return 1;
            }
            return Convert.ToInt32(single);
        }

        public void Delete(int RoleId)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Role where RoleId=@RoleId");
            System.Data.OleDb.OleDbParameter[] cmdPams = new System.Data.OleDb.OleDbParameter[]
            {
                new System.Data.OleDb.OleDbParameter("@RoleId",System.Data.OleDb.OleDbType.Integer)
              
            };

            cmdPams[0].Value = RoleId;
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString(), cmdPams);

        }

        public void Update(string[] FieldValues, int RoleId, params string[] FieldNames)
        {
            KstSoft.DBUtility.OleDB_Helper.DataUpdate("Role", "RoleId", RoleId.ToString(), FieldValues, FieldNames);
        }

        public System.Data.DataSet GetList(params string[] FieldNames)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(0, FieldNames));
            sb.Append(" from Role");
            return KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString());
        }

        public KstCMS.Model.SiteModel.AdminRole GetMode(int RoleId)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(string.Format("select * from Role where Role={0}", RoleId));
            System.Data.OleDb.OleDbDataReader dr = KstSoft.DBUtility.OleDB_Helper.ExecuteReader(sb.ToString());
            KstCMS.Model.SiteModel.AdminRole Model = new Model.SiteModel.AdminRole();
            if (dr.Read())
            {
                Model.RoleId = Convert.ToInt32(dr["RoleId"].ToString());
                Model.RoleName = dr["RoleName"].ToString();
                Model.RunCode = dr["RunCode"].ToString();
            }
            return Model;
        }


    }
}
