﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.DAL.OleDB
{
    [Serializable]
    public class WebSite:KstCMS.DAL.IWebSite
    {
        public int Add(KstCMS.Model.SiteModel.WebSite Model)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into WebSite(");
            sb.Append("SiteVer, VerName, SiteName, SiteTitle, MateKey, MateDesc, CopyRight, DefaultSite, SortNO, SiteACT, TempID)");
            sb.Append(" values(");
            sb.Append("@SiteVer, @VerName, @SiteName, @SiteTitle, @MateKey, @MateDesc, @CopyRight, @DefaultSite, @SortNO, @SiteACT, @TempID)");
            sb.Append(";select @@IDENTITY");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@SiteVer",System.Data.OleDb.OleDbType.VarChar,10),
               new System.Data.OleDb.OleDbParameter("@VerName",System.Data.OleDb.OleDbType.VarChar,50),
               new System.Data.OleDb.OleDbParameter("@SiteName",System.Data.OleDb.OleDbType.VarChar,50),
               new System.Data.OleDb.OleDbParameter("@SiteTitle",System.Data.OleDb.OleDbType.VarChar,200),
               new System.Data.OleDb.OleDbParameter("@MateKey",System.Data.OleDb.OleDbType.LongVarChar),
               new System.Data.OleDb.OleDbParameter("@MateDesc",System.Data.OleDb.OleDbType.LongVarChar),
               new System.Data.OleDb.OleDbParameter("@CopyRight",System.Data.OleDb.OleDbType.LongVarChar),
               new System.Data.OleDb.OleDbParameter("@DefaultSite",System.Data.OleDb.OleDbType.SmallInt),
               new System.Data.OleDb.OleDbParameter("@SortNO",System.Data.OleDb.OleDbType.Integer),
               new System.Data.OleDb.OleDbParameter("@SiteACT",System.Data.OleDb.OleDbType.SmallInt),
               new System.Data.OleDb.OleDbParameter("@TempID",System.Data.OleDb.OleDbType.Integer),
           };
            cmdParms[0].Value = Model.SiteVer;
            cmdParms[1].Value = Model.VerName;
            cmdParms[2].Value = Model.SiteName;
            cmdParms[3].Value = Model.SiteTitle;
            cmdParms[4].Value = Model.MetaKey;
            cmdParms[5].Value = Model.MetaDesc;
            cmdParms[6].Value = Model.CopyRight;
            cmdParms[7].Value = Model.DefaultSite;
            cmdParms[8].Value = Model.SortNO;
            cmdParms[9].Value = Model.SiteACT;
            cmdParms[10].Value = Model.TempID;
            object single = KstSoft.DBUtility.OleDB_Helper.GetSingle(sb.ToString(), cmdParms);
            if (single == null)
            {
                return 1;
            }
            return Convert.ToInt32(single);
        }

        public void Add(string[] FieldValues, params string[] FieldNames)
        {
            KstSoft.DBUtility.OleDB_Helper.DataInsert("WebSite", FieldValues, FieldNames);
        }

        public void Delete(int SiteId)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from WebSite where SiteID=@id");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@id",System.Data.OleDb.OleDbType.Integer)
           };
            cmdParms[0].Value = SiteId;
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString(), cmdParms);
        }

        public void Update(KstCMS.Model.SiteModel.WebSite Model)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update WebSite set ");
            sb.Append("SiteVer=@SiteVer, VerName=@VerName, SiteName=@SiteName, SiteTitle=@SiteTitle, ");
            sb.Append("MateKey=@MateKey, MateDesc=@MateDesc, CopyRight=@CopyRight, DefaultSite=@DefaultSite, SortNO=@SortNO, SiteACT=@SiteACT, TempID=@TempID ");
            sb.Append("where SiteID=@id");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@id",System.Data.OleDb.OleDbType.Integer),
               new System.Data.OleDb.OleDbParameter("@SiteVer",System.Data.OleDb.OleDbType.VarChar,10),
               new System.Data.OleDb.OleDbParameter("@VerName",System.Data.OleDb.OleDbType.VarChar,50),
               new System.Data.OleDb.OleDbParameter("@SiteName",System.Data.OleDb.OleDbType.VarChar,50),
               new System.Data.OleDb.OleDbParameter("@SiteTitle",System.Data.OleDb.OleDbType.VarChar,200),
               new System.Data.OleDb.OleDbParameter("@MateKey",System.Data.OleDb.OleDbType.LongVarChar),
               new System.Data.OleDb.OleDbParameter("@MateDesc",System.Data.OleDb.OleDbType.LongVarChar),
               new System.Data.OleDb.OleDbParameter("@CopyRight",System.Data.OleDb.OleDbType.LongVarChar),
               new System.Data.OleDb.OleDbParameter("@DefaultSite",System.Data.OleDb.OleDbType.SmallInt),
               new System.Data.OleDb.OleDbParameter("@SortNO",System.Data.OleDb.OleDbType.Integer),
               new System.Data.OleDb.OleDbParameter("@SiteACT",System.Data.OleDb.OleDbType.SmallInt),
               new System.Data.OleDb.OleDbParameter("@TempID",System.Data.OleDb.OleDbType.Integer),
           };
            cmdParms[0].Value = Model.SiteID;
            cmdParms[1].Value = Model.SiteVer;
            cmdParms[2].Value = Model.VerName;
            cmdParms[3].Value = Model.SiteName;
            cmdParms[4].Value = Model.SiteTitle;
            cmdParms[5].Value = Model.MetaKey;
            cmdParms[6].Value = Model.MetaDesc;
            cmdParms[7].Value = Model.CopyRight;
            cmdParms[8].Value = Model.DefaultSite;
            cmdParms[9].Value = Model.SortNO;
            cmdParms[10].Value = Model.SiteACT;
            cmdParms[11].Value = Model.TempID;
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString(), cmdParms);
        }

        public void Update(string[] FieldsValues, int SiteId, params string[] FieldNames)
        {
            KstSoft.DBUtility.OleDB_Helper.DataUpdate("WebSite", "SiteID", SiteId.ToString(), FieldsValues, FieldNames);
        }

        public void Set_DefaultSite(int SiteId)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("update WebSite set DefaultSite=0;");
            sb.Append("update WebSite set DefaultSite=1 ");
            sb.Append("where SiteID=@ID");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@ID",System.Data.OleDb.OleDbType.Integer)
           };
            cmdParms[0].Value = SiteId;
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString(), cmdParms);
        }
        /// <summary>
        /// 指定的WebSite中的SiteID是否存在
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool Exists(int SiteId)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select count(1) from WebSite");
            sb.Append(" where SiteID=@id ");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[] { new System.Data.OleDb.OleDbParameter("@id", System.Data.OleDb.OleDbType.Integer) };
            cmdParms[0].Value = SiteId;
            return KstSoft.DBUtility.OleDB_Helper.Exists(sb.ToString(), cmdParms);
        }

        public bool Exists(string SiteVer)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select count(1) from WebSite");
            sb.Append(" where SiteVer=@SiteVer ");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[] { new System.Data.OleDb.OleDbParameter("@SiteVer", System.Data.OleDb.OleDbType.VarChar) };
            cmdParms[0].Value = SiteVer;
            return KstSoft.DBUtility.OleDB_Helper.Exists(sb.ToString(), cmdParms);
        }


        /// <summary>
        /// 跟据特定条件取WebSite数据集
        /// </summary>
        /// <param name="strWhere">SQL的WHERE 条件,默认没有条件</param>
        /// <param name="OrderBy">排序语句,默认没排序</param>
        /// <param name="Top">显示最多记录数,默认为0,显示所有记录</param>
        /// <param name="FieldName">选择显示的字段名</param>
        /// <returns>数据集Dataset</returns>
        public System.Data.DataSet GetList(string strWhere, string OrderBy, int Top, params string[] FieldName)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(Top, FieldName));
            sb.Append(" from WebSite");
            if (!string.IsNullOrEmpty(strWhere))
            {
                sb.Append(" where " + strWhere);
            }
            if (!string.IsNullOrEmpty(OrderBy))
            {
                sb.Append(" order by " + OrderBy);
            }
            return KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString());
        }

        public int GetMaxId()
        {
            return KstSoft.DBUtility.OleDB_Helper.GetMaxID("SiteID", "WebSite");
        }

        public KstCMS.Model.SiteModel.WebSite GetModel(int id, params string[] FieldName)
        {
            KstCMS.Model.SiteModel.WebSite Site = new Model.SiteModel.WebSite();
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(0, FieldName));
            sb.Append(" from WebSite where SiteID=@ID");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@ID",System.Data.OleDb.OleDbType.Integer)
           };
            cmdParms[0].Value = id;
            System.Data.DataSet dsData = KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString(), cmdParms);
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string Field = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], Field, ref Site);
                }
            }
            return Site;
        }


        private void GetField(System.Data.DataRow Row, string FieldName, ref KstCMS.Model.SiteModel.WebSite WebSite)
        {
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "SiteID":
                    WebSite.SiteID = Convert.ToInt32(FieldValue);
                    break;
                case "SiteVer":
                    WebSite.SiteVer = FieldValue;
                    break;
                case "VerName":
                    WebSite.VerName = FieldValue;
                    break;
                case "SiteName":
                    WebSite.SiteName = FieldValue;
                    break;
                case "SiteTitle":
                    WebSite.SiteTitle = FieldValue;
                    break;
                case "MateKey":
                    WebSite.MetaKey = FieldValue;
                    break;
                case "MateDesc":
                    WebSite.MetaDesc = FieldValue;
                    break;
                case "CopyRight":
                    WebSite.CopyRight = FieldValue;
                    break;
                case "DefaultSite":
                    WebSite.DefaultSite = Convert.ToInt32(FieldValue);
                    break;
                case "SortNO":
                    WebSite.SortNO = Convert.ToInt32(FieldValue);
                    break;
                case "SiteACT":
                    WebSite.SiteACT = Convert.ToInt32(FieldValue);
                    break;
                case "TempID":
                    WebSite.TempID = Convert.ToInt32(FieldValue);
                    break;

            }

        }
    }
}
