﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;
using System.Xml.Linq;
namespace KstCMS
{
    public class Global : System.Web.HttpApplication
    {

        void Application_Start(object sender, EventArgs e)
        {
            // 在应用程序启动时运行的代码

        }

        void Application_End(object sender, EventArgs e)
        {
            //  在应用程序关闭时运行的代码

        }

        void Application_Error(object sender, EventArgs e)
        {
            // 在出现未处理的错误时运行的代码

        }

        void Session_Start(object sender, EventArgs e)
        {
            // 在新会话启动时运行的代码
            // 取KstCMS.config最后一次修改时间
            string ConfigPath = KstCmsBase.Common.Fucs.GetRootURI() + "/KstCMS.config";
            Application["KstcmsConfig"] = System.IO.File.GetLastWriteTime(Server.MapPath(ConfigPath));

        }

        void Session_End(object sender, EventArgs e)
        {
            // 在会话结束时运行的代码。 
            // 注意: 只有在 Web.config 文件中的 sessionstate 模式设置为
            // InProc 时，才会引发 Session_End 事件。如果会话模式设置为 StateServer 
            // 或 SQLServer，则不会引发该事件。
            Hashtable hOnline = (Hashtable)Application["Online"];
            if (hOnline[Session.SessionID] != null)
            {
                hOnline.Remove(Session.SessionID);
                Application.Lock();
                Application["Online"] = hOnline;
                Application.UnLock();
            }

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {
            if (Request.IsAuthenticated == true)
            {
                try
                {
                    String FormsCookieName = FormsAuthentication.FormsCookieName;

                    KstCmsBase.Entities.UsersEntity TTUser = KstCmsBase.DAL.Users.Get_UserInfo(User.Identity.Name);
                    FormsAuthenticationTicket Ticket = new FormsAuthenticationTicket(
                        1,
                        Context.User.Identity.Name,
                        DateTime.Now,
                        DateTime.Now.AddDays(1),
                        false,
                        User.Identity.Name + "|" + TTUser.UserId 
                        );
                    String CookieStr = FormsAuthentication.Encrypt(Ticket);
                    HttpCookie Cookie = new HttpCookie(FormsCookieName, CookieStr);
                    Cookie.Path = "/";
                    Cookie.Expires = DateTime.Now.AddDays(1);
                    Response.Cookies.Add(Cookie);



                }
                catch (Exception Err)
                {
                    Response.Write("<script>alert(\"" + Err.Message.Replace("\r\n", "\\r\\n") + "\");history.go(-1);</script>");
                    Response.End();
                }


            }
        }

    }
}
