﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.CreateWeb.Html
{
    public partial class Create_ListPage : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            ProLB_btn.Click += new EventHandler(ProLB_btn_Click);
            WzListBtn.Click += new EventHandler(WzListBtn_Click);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                ShowMenuDrp();
                ShowProLb();
                ShowWzLB();
                drp_MenuList.Attributes.Add("onchange", "IntMsg();");
            }
        }

        void WzListBtn_Click(object sender, EventArgs e)
        {
            foreach (ListItem item in WzLBlistbox.Items)
            {
                if (item.Selected)
                {
                    KstWEB.SiteWeb.CreateWzListOnPage(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), Convert.ToInt32(item.Value));
                }
            }
            ShowMsgModle("生成成功！");
        }

        void ProLB_btn_Click(object sender, EventArgs e)
        {
           // System.Threading.Thread Thd = new System.Threading.Thread(new System.Threading.ThreadStart(this.CreateProList));
           // Thd.Start();
            CreateProList();
            ShowMsgModle("生成成功！");
        }

        void CreateProList()
        {
            foreach (ListItem item in ProLBListBox.Items)
            {
                if (item.Selected)
                {
                    string ClassId = string.Empty;
                   // System.Threading.Thread.Sleep(2000);
                    KstCmsBase.DAL.Product.ProLB.GetAny_ParentLBID(item.Value, ref ClassId);
                    KstWEB.SiteWeb.CreateProListOnPage(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), Convert.ToInt32(item.Value), ClassId);
                }
            }
            //ShowMsgModle("生成成功！");
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowProLb();
            ShowWzLB();
        }

        void ShowProLb()
        {
            ProLBListBox.Items.Clear();
            DropDownList Drp = new DropDownList();
            KstCmsBase.Common.HtmlControl.ProLB_HtmlControls WebControl = new KstCmsBase.Common.HtmlControl.ProLB_HtmlControls(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
            WebControl.Showdrp_LBID(0, ref Drp);
            foreach (ListItem lbitem in Drp.Items)
            {
                ProLBListBox.Items.Add(lbitem);
            }
            Drp.Dispose();
            if (ProLBListBox.Items.Count < 1)
                ProLB_btn.Enabled = false;
            else
                ProLB_btn.Enabled = true;
        }

        void ShowWzLB()
        {
            WzLBlistbox.Items.Clear();
            if (drp_MenuList.SelectedValue != "0")
            {
                KstCmsBase.Collection.Wz.WzLBCollection WzLBITEMS = KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue));
                foreach (KstCmsBase.Entities.Wz.WzLB_Ent lbitem in WzLBITEMS)
                {
                    ListItem item = new ListItem();
                    item.Value = lbitem.LbID.ToString();
                    item.Text = lbitem.LbName;
                    WzLBlistbox.Items.Add(item);
                }
            }
            if (WzLBlistbox.Items.Count < 1)
                WzListBtn.Enabled = false;
            else
                WzListBtn.Enabled = true;
        }



        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp();
            
        }

        void ShowMenuDrp()
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenu = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(drp_SiteList.SelectedValue), "MenuID", "MenuName");
            foreach (KstCmsBase.Entities.WebMenu_ent Menu in WebMenu)
            {
                ListItem item = new ListItem();
                item.Value = Menu.MenuID.ToString();
                item.Text = Menu.MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选择", "0"));
        }


        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
        }
    }
}