﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.Manager.Feeback.query
{
    public partial class index : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_LbList.SelectedIndexChanged += new EventHandler(drp_LbList_SelectedIndexChanged);
            link_cname.Click += new EventHandler(link_cname_Click);
            link_title.Click += new EventHandler(link_title_Click);
            link_time.Click += new EventHandler(link_time_Click);
            btn_Del.Click += new EventHandler(btn_Del_Click);
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                ShowLBdrp();
                ViewState["IsDOWN"] = true;
                ViewState["Sort"] = KstCmsBase.Collection.Feeback.LyListCollection.SortFields.Lytime;
                repMain_bind();
            }
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                string ReTime = ((KstCmsBase.Entities.Feeback.LyEnt)e.Item.DataItem).ReTime.ToString();
                if(!string.IsNullOrEmpty(ReTime))
                   ((Literal)e.Item.FindControl("Literal2")).Text = string.Format("{0:yyyy-MM-dd hh:mm:ss}",Convert.ToDateTime(ReTime));
            }
        }

        void btn_Del_Click(object sender, EventArgs e)
        {
            string Lyids = Request.Form.Get("chxbox");
            if (!string.IsNullOrEmpty(Lyids))
            {
                string[] ids = Lyids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                foreach (string id in ids)
                {
                    KstCmsBase.DAL.Feeback.Ly.Lydelete(Convert.ToInt32(id));
                }
            }
            repMain_bind();
        }

        void link_time_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Feeback.LyListCollection.SortFields.Lytime;
            repMain_bind();
        }

        void link_title_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Feeback.LyListCollection.SortFields.LyTitle;
            repMain_bind();
        }

        void link_cname_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Feeback.LyListCollection.SortFields.Cname;
            repMain_bind();
        }

        void drp_LbList_SelectedIndexChanged(object sender, EventArgs e)
        {
            repMain_bind();
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            repMain_bind();
        }
        void repMain_bind()
        {
            KstCmsBase.Collection.Feeback.LyListCollection LyITEMS = KstCmsBase.DAL.Feeback.Ly.GetLyList(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_LbList.SelectedValue));

            KstCmsBase.Collection.Feeback.LyListCollection.SortFields Sort = (KstCmsBase.Collection.Feeback.LyListCollection.SortFields)ViewState["Sort"];

            if ((bool)ViewState["IsDOWN"] == true)
                LyITEMS.Sort(Sort, false);
            else
                LyITEMS.Sort(Sort, true);
            AspNetPager1.RecordCount = LyITEMS.Count;
            System.Collections.ArrayList Items = null;
            if (AspNetPager1.RecordCount == 0)
                AspNetPager1.CurrentPageIndex = 0;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                Items = LyITEMS.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
            }
            else
            {
                int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                Items = LyITEMS.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
            }
            PageInfo.Text = "<span style=\"color:red\">" + this.AspNetPager1.RecordCount.ToString() + "</span> ," + this.AspNetPager1.CurrentPageIndex.ToString() + "/" + this.AspNetPager1.PageCount.ToString();
            RepMain.DataSource = Items;
            RepMain.DataBind();
        }
        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            repMain_bind();

        }
        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);

            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();
        }
        void ShowLBdrp()
        {
            KstCmsBase.Collection.Feeback.LyLbCollection items = KstCmsBase.DAL.Feeback.Ly.Get_LyLBitems();
            foreach (KstCmsBase.Entities.Feeback.LyLbEnt lbitem in items)
            {
                ListItem item = new ListItem();
                item.Value = lbitem.LbID.ToString();
                item.Text = lbitem.LbName;
                drp_LbList.Items.Add(item);
            }

        }
    }
}