﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.Manager.Link.query
{
    public partial class EditFrm : KstCmsBase.WebPage.FrmControl
    {
        string Linkid = System.Web.HttpContext.Current.Request.QueryString.Get("Linkid");
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                GetLinkinfo();
                SetControl();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            if (logofile.Value.ToLower() != txt_Logo.Text.Trim())
            {
                KstCmsBase.Common.Fucs.DeleteFile(Server.MapPath(logofile.Value));
            }
            string Act = chk_Act.Checked ? "1" : "0";
            string isHome = chk_isHome.Checked ? "1" : "0";
            string[] data = new string[]{
                drp_LbList.SelectedValue,
                drp_SiteList.SelectedValue,
                drp_MenuList.SelectedValue,
                txt_SiteName.Text.Trim(),
                txt_LinkName.Text.Trim(),
                txt_LinkUrl.Text.Trim(),
                txt_Logo.Text.Trim(),
                Act,
                isHome};
            KstCmsBase.DAL.Link.FLink.Link_Update(Convert.ToInt32(Linkid),data, "LbID", "SiteID", "MenuID", "SiteName", "LinkName", "LinkUrl", "LogoUrl", "Act", "isHome");
            ShowMsgModle("修改成功！");
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
        }

        void GetLinkinfo()
        {
            KstCmsBase.Entities.Link.LinkEnt Link = KstCmsBase.DAL.Link.FLink.Get_LinkInfo(Convert.ToInt32(Linkid));
            ShowSiteDrp();
            drp_SiteList.SelectedValue = Link.SiteID.ToString();
            ShowMenuDrp(drp_SiteList.SelectedValue);
            drp_MenuList.SelectedValue = Link.MenuID.ToString();
            ShowLBdrp();
            drp_LbList.SelectedValue = Link.LbID.ToString();
            txt_SiteName.Text = Link.SiteName;
            txt_LinkName.Text = Link.LinkName;
            txt_LinkUrl.Text = Link.LinkUrl;
            txt_Logo.Text = Link.LogoUrl;
            chk_Act.Checked = Link.Act == 1;
            chk_isHome.Checked = Link.isHome == 1;
            logofile.Value = Link.LogoUrl;
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);

            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection MenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), "MenuID", "MenuName");
            foreach (KstCmsBase.Entities.WebMenu_ent Menu in MenuItems)
            {
                ListItem item = new ListItem();
                item.Value = Menu.MenuID.ToString();
                item.Text = Menu.MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选择所属导航", "0"));
        }

        void ShowLBdrp()
        {
            drp_LbList.Items.Clear();
            KstCmsBase.Collection.Link.LinkLBCollection items = KstCmsBase.DAL.Link.FLink.Get_LinkLB_Items();
            foreach (KstCmsBase.Entities.Link.LinkLB lbitem in items)
            {
                ListItem item = new ListItem();
                item.Value = lbitem.LbID.ToString();
                item.Text = lbitem.LbName;
                drp_LbList.Items.Add(item);
            }

        }
        void SetControl()
        {
            string[] Cons = new string[]{
                "所属导航~!",
                "网站名称~!",
                "链接名称~!",
                "链接地址~!"};
            base.Set_Control(Cons, drp_MenuList, txt_SiteName, txt_LinkName, txt_LinkUrl);
        }
    }
}