﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.Module.Upload
{
    public partial class Upload : KstCmsBase.WebPage.ValiPage
    {
        string FromUpload = System.Web.HttpContext.Current.Request.QueryString.Get("FromUpload");
       // protected string ParentTextBox = System.Web.HttpContext.Current.Request.QueryString.Get("TextBoxId");
        protected void Page_Load(object sender, EventArgs e)
        {
            Button1.Click += new EventHandler(Button1_Click);
        }

        void Button1_Click(object sender, EventArgs e)
        {
            int FileSize = 0;
            string[] FileExt = null;
            string Path = string.Empty;
            switch (FromUpload)
            {
                case "0"://产品缩略图
                    ProPic_upload(ref FileSize, ref FileExt, ref Path);
                    break;
                case "1": //产品相关下载文件
                    Profile_upload(ref FileSize, ref FileExt, ref Path);
                    break;
                case "2": //产品图片集
                     ProPicItems_upload(ref FileSize, ref FileExt, ref Path);
                     break;
                case "3":  //文章图片集
                     WzPic_upload(ref FileSize, ref FileExt, ref Path);
                     break;
                case "4": //图片播放
                     PicPlay_upload(ref FileSize, ref FileExt, ref Path);
                    break;
                case "5":
                    Path = SysRootUrl + "/upload/Link/";
                    FileExt = new string[] { ".jpg"};
                    FileSize = 102400;
                    break;
            }
            FileUpload(FileSize, FileExt, Path);
        }



        private void ProPic_upload(ref int FileSize, ref string[] FileExt, ref string Path)
        {
            string UploadPath = string.Empty;
            if (Read_Cache("productpic_path") != null)
                UploadPath = Read_Cache("productpic_path").ToString();
            else
            {
                UploadPath = SysRootUrl + "/" + KstCmsBase.Common.Fucs.GetConfigValue("productpic_path");
                Set_Cache("productpic_path", UploadPath);
                //System.Web.HttpContext.Current.Cache.Add("productpic_path", UploadPath, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }

            if (Read_Cache("Product_PicSize") != null)
                FileSize = Convert.ToInt32(Read_Cache("Product_PicSize"));
            else
            {
                FileSize = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("Product_PicSize"));
                Set_Cache("Product_PicSize", FileSize);
                //System.Web.HttpContext.Current.Cache.Add("Product_PicSize", FileSize, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }
            Path = UploadPath + "/" + DateTime.Now.ToString("yyyy-MM-dd") + "/";
            FileExt = new string[] { ".jpg", ".png", ".gif" };
        }

        private void Profile_upload(ref int FileSize, ref string[] FileExt, ref string Path)
        {
            string UploadPath = string.Empty;
            if (Read_Cache("productfile_path") != null)
                UploadPath = Read_Cache("productfile_path").ToString();
            else
            {
                UploadPath = SysRootUrl + "/" + KstCmsBase.Common.Fucs.GetConfigValue("productfile_path");
                Set_Cache("productfile_path", UploadPath);
                //System.Web.HttpContext.Current.Cache.Add("productfile_path", UploadPath, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }


            if (Read_Cache("productfile_size") != null)
                FileSize = Convert.ToInt32(Read_Cache("productfile_size"));
            else
            {
                FileSize = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("productfile_size"));
                Set_Cache("productfile_size", FileSize);
                //System.Web.HttpContext.Current.Cache.Add("productfile_size", FileSize, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }

            string UpType = string.Empty;
            if (Read_Cache("productfile_type") != null)
                UpType = Read_Cache("productfile_type").ToString();
            else
            {
                UpType = KstCmsBase.Common.Fucs.GetConfigValue("productfile_type");
                Set_Cache("productfile_type", UpType);
                //System.Web.HttpContext.Current.Cache.Add("productfile_size", UpType, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }

            Path = UploadPath + "/" + DateTime.Now.ToString("yyyy-MM-dd") + "/";
            FileExt = UpType.Split(new string[] { "|" }, StringSplitOptions.RemoveEmptyEntries);
        }

        private void PicPlay_upload(ref int FileSize, ref string[] FileExt, ref string Path)
        {
            if (Read_Cache("playpic_size") != null)
            {
                FileSize = Convert.ToInt32(Read_Cache("playpic_size"));
            }
            else
            {
                FileSize = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("playpic_size"));
                Set_Cache("playpic_size", FileSize);
                //System.Web.HttpContext.Current.Cache.Add("playpic_size", FileSize, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }
            FileExt = new string[] { ".jpg" };
            Path = SysRootUrl + "/upload/PlayPic/";
        }

        private void WzPic_upload(ref int FileSize, ref string[] FileExt, ref string Path)
        {
            string UploadPath = string.Empty;
            if (Read_Cache("wzpic_path") != null)
                UploadPath = Read_Cache("wzpic_path").ToString();
            else
            {
                UploadPath = SysRootUrl + "/" + KstCmsBase.Common.Fucs.GetConfigValue("wzpic_path");
                Set_Cache("wzpic_path", UploadPath);
                //System.Web.HttpContext.Current.Cache.Add("wzpic_path", UploadPath, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }


            if (Read_Cache("wzpic_size") != null)
                FileSize = Convert.ToInt32(Read_Cache("wzpic_size"));
            else
            {
                FileSize = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("wzpic_size"));
                Set_Cache("wzpic_size", FileSize);
               // System.Web.HttpContext.Current.Cache.Add("wzpic_size", FileSize, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }


            Path = UploadPath + "/" + DateTime.Now.ToString("yyyy-MM-dd") + "/";
            FileExt = new string[] { ".jpg", ".png", ".gif" };
        }

        private void ProPicItems_upload(ref int FileSize, ref string[] FileExt, ref string Path)
        {
            string UploadPath = string.Empty;
            if (Read_Cache("ProlbIMGPath") != null)
                UploadPath = Read_Cache("ProlbIMGPath").ToString();
            else
            {
                UploadPath = SysRootUrl + "/" + KstCmsBase.Common.Fucs.GetConfigValue("ProlbIMGPath");
                Set_Cache("ProlbIMGPath", UploadPath);
                //System.Web.HttpContext.Current.Cache.Add("ProlbIMGPath", UploadPath, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }



            if (Read_Cache("ProlbIMGSize") != null)
                FileSize = Convert.ToInt32(Read_Cache("ProlbIMGSize"));
            else
            {
                FileSize = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("ProlbIMGSize"));
                Set_Cache("ProlbIMGSize", FileSize);
                //System.Web.HttpContext.Current.Cache.Add("ProlbIMGSize", FileSize, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }


            Path = UploadPath + "/" + DateTime.Now.ToString("yyyy-MM-dd") + "/";
            FileExt = new string[] { ".jpg", ".png", ".gif" };
        }

        void FileUpload(int Size, string[] FileType, string Path)
        {
            try
            {
                KstCmsBase.Common.FStream FS = new KstCmsBase.Common.FStream(Size, FileType);
                string UploadFileUrl = FS.UploadFile(this.FileUpload1, Path);
                Page.ClientScript.RegisterStartupScript(this.Page.GetType(), "MsgStr", "parent.UpdateParentTxt('" + UploadFileUrl + "');", true);
            }
            catch (Exception e)
            {
                Page.ClientScript.RegisterStartupScript(this.Page.GetType(), "MsgStr", "window.alert(\"" + e.Message + "\");", true);
            }
            finally
            {
            }
        }


    }
}