﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.SystemSet.SoftFace.Menu
{
    public partial class MasterMenuList : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            repMain.ItemCommand += new RepeaterCommandEventHandler(repMain_ItemCommand);
            repMain.ItemDataBound += new RepeaterItemEventHandler(repMain_ItemDataBound);
            BindData();
        }

        void repMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                ((LinkButton)e.Item.FindControl("LinkButton1")).Enabled = isAdmin;
            }
        }

        void repMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            KstCmsBase.DAL.SysMenu.SysMenu_Delete(e.CommandName);
            BindData();
        }


        private void BindData()
        {
            KstCmsBase.Collection.SysMenuCollection MenuCollections = KstCmsBase.DAL.SysMenu.Get_SysMasterMenu();
            repMain.DataSource = MenuCollections;
            repMain.DataBind();
        }
    }
}