﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.SystemSet.Users.urs
{
    public partial class index : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            if (!IsPostBack)
            {
                Show_RoleDropdown();
                Bind();
            }
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int Act = Convert.ToInt32(e.CommandArgument.ToString());
            switch (Act)
            {
                case 0:
                    KstCmsBase.DAL.Users.Set_UserAction(e.CommandName.Trim());
                    break;
                case 1:
                    KstCmsBase.DAL.Users.Set_UserPwd(e.CommandName.Trim(), System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(string.Empty, "MD5"));
                    ShowMsgModle("密码修改成功！");
                    break;
                case 2:
                    KstCmsBase.DAL.Users.User_Delete(e.CommandName.Trim());
                    break;
            }
            Bind();
        }



        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                int Actstr = ((KstCmsBase.Entities.UsersEntity)e.Item.DataItem).Act;
                int isAdmin = ((KstCmsBase.Entities.UsersEntity)e.Item.DataItem).isAdmin;

                if (Actstr == 0)
                {
                    ((ImageButton)e.Item.FindControl("ImageButton1")).ImageUrl = SysRootUrl + "/KstCMS_Manager/images/enable.gif";
                }
                else
                {
                    ((ImageButton)e.Item.FindControl("ImageButton1")).ImageUrl = SysRootUrl + "/KstCMS_Manager/images/disable.gif";
                }
                ///管理员用户禁止删除            
                if (isAdmin != 1)
                {
                    ((LinkButton)e.Item.FindControl("LinkButton2")).Visible = true;
                    //((LinkButton)e.Item.FindControl("LinkButton1")).Visible = base.isAdmin;
                    
                }
                else
                {
                    ((LinkButton)e.Item.FindControl("LinkButton2")).Visible = false;
                    ((LinkButton)e.Item.FindControl("LinkButton1")).Visible = base.isAdmin;
                }
                
                

            }
        }

        protected void SearchBtn_Click(object sender, EventArgs e)
        {

            Bind();
        }

        protected void Bind()
        {

                KstCmsBase.Collection.Usersollection UserCollection = new KstCmsBase.Collection.Usersollection();

                if (RoleId.SelectedValue == "all")
                    UserCollection = KstCmsBase.DAL.Users.Get_UserList();
                else
                    UserCollection = KstCmsBase.DAL.Users.Get_UserList(Convert.ToInt32(RoleId.SelectedValue));

            System.Collections.ArrayList items = null;
            AspNetPager1.RecordCount = UserCollection.Count;
            if (AspNetPager1.RecordCount == 0)
                AspNetPager1.CurrentPageIndex = 0;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                items=UserCollection.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
            }
            else
            {
                int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                items=UserCollection.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
            }
            RepMain.DataSource = items;
            RepMain.DataBind();



        }

        public void Show_RoleDropdown()
        {
            KstCmsBase.Collection.RoleCollection RoleItems = KstCmsBase.DAL.Role.Get_RoleList();
            foreach (KstCmsBase.Entities.RoleEntity Role in RoleItems)
            {
                ListItem item = new ListItem();
                item.Value = Role.RoleId.ToString();
                item.Text = Role.RoleName;
                RoleId.Items.Add(item);
            }
            RoleId.Items.Insert(0, new ListItem("所有角色", "all"));
        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            Bind();

        }
    }
}