﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.products.pro
{
    public partial class FileList : KstCmsBase.WebPage.ValidationPage
    {
        string ProID = System.Web.HttpContext.Current.Request.QueryString.Get("ProID");
        protected void Page_Load(object sender, EventArgs e)
        {
            Button1.Click += new EventHandler(Button1_Click);
            btn_Del.Click += new EventHandler(btn_Del_Click);
            btn_Sort.Click += new EventHandler(btn_Sort_Click);
            if (!IsPostBack)
            {
                RepMain_bind();
            }
        }

        void btn_Sort_Click(object sender, EventArgs e)
        {
            string[] PicIds = Request.Form.Get("chxbox").Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            if (PicIds.Length < 1)
                throw new Exception("没指定要更新的图片！");
            for (int i = 0; i < PicIds.Length; i++)
            {
                string PicName = Request.Form.Get("FileName_" + PicIds[i]);
                string SortNo = Request.Form.Get("SortNo_" + PicIds[i]);
                string[] data = new string[] { PicName, SortNo };
                KstCmsBase.DAL.Product.Product.ProductFile_Update("DownID", Convert.ToInt32(PicIds[i]), data, "FileName", "SortNo");
            }
            RepMain_bind();
        }

        void btn_Del_Click(object sender, EventArgs e)
        {
            string[] PicIds = Request.Form.Get("chxbox").Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            if (PicIds.Length < 1)
                throw new Exception("没指定要删除的文件！");
            for (int i = 0; i < PicIds.Length; i++)
            {
                KstCmsBase.DAL.Product.Product.ProductFile_delete(Convert.ToInt32(PicIds[i]));
            }
            RepMain_bind();
        }

        void Button1_Click(object sender, EventArgs e)
        {

            
            if (string.IsNullOrEmpty(txt_FilePath.Text.Trim()))
                throw new Exception("操作错误，请先上传一文件再做保存操作！");
            if (!System.IO.File.Exists(Server.MapPath(txt_FilePath.Text.Trim())))
                throw new Exception("操作借误，输入框的文件不存在！，请重新上传一下");
            System.IO.FileStream fs = System.IO.File.Open(Server.MapPath(txt_FilePath.Text.Trim()),System.IO.FileMode.Open);
            long FileSize = fs.Length;
            fs.Close();
            

            string SortNo = (KstCmsBase.DAL.Product.Product.GetDescFieldList(ProID).Count + 1).ToString();
            string[] data = new string[]{
                ProID,
                txt_FileName.Text.Trim(),
                txt_FilePath.Text.Trim(),
                FileSize.ToString(),
                DateTime.Now.ToString("yyyy-MM-dd"),
                SortNo
            };

            KstCmsBase.DAL.Product.Product.ProductFile_Insert(data, "ProID", "FileName", "FilePath", "FileSize", "uTime", "SortNo");
            RepMain_bind();

        }

        void RepMain_bind()
        {
            KstCmsBase.Collection.Product.ProductFileCollection FileItems = KstCmsBase.DAL.Product.Product.GetProductFiles(ProID);
            AspNetPager1.RecordCount = FileItems.Count;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                FileItems.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize - 1);
            }
            else
            {
                FileItems.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.RecordCount);
            }
            PageInfo.Text = "<span style=\"color:red\">" + this.AspNetPager1.RecordCount.ToString() + "</span> ," + this.AspNetPager1.CurrentPageIndex.ToString() + "/" + this.AspNetPager1.PageCount.ToString();
            RepMain.DataSource = FileItems;
            RepMain.DataBind();

        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            RepMain_bind();

        }
    }
}