﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.products.pro
{
    public partial class PicList : KstCmsBase.WebPage.ValidationPage
    {
        string ProID = System.Web.HttpContext.Current.Request.QueryString.Get("ProID");
        protected void Page_Load(object sender, EventArgs e)
        {
            Button1.Click += new EventHandler(Button1_Click);
            btn_Del.Click += new EventHandler(btn_Del_Click);
            btn_Sort.Click += new EventHandler(btn_Sort_Click);
            if (!IsPostBack)
            {
                RepMain_bind();
            }
        }

        void btn_Sort_Click(object sender, EventArgs e)
        {
            string[] PicIds = Request.Form.Get("chxbox").Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            if (PicIds.Length < 1)
                throw new Exception("没指定要更新的图片！");
            for (int i = 0; i < PicIds.Length; i++)
            {
                string PicName = Request.Form.Get("FileName_" + PicIds[i]);
                string SortNo = Request.Form.Get("SortNo_" + PicIds[i]);
                string[] data = new string[] { PicName, SortNo };
                KstCmsBase.DAL.Product.Product.ProductPic_Update("PicID", Convert.ToInt32(PicIds[i]), data, "PicName", "SortNo");
            }
            RepMain_bind();
        }

        void btn_Del_Click(object sender, EventArgs e)
        {
            string[] PicIds = Request.Form.Get("chxbox").Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            if (PicIds.Length < 1)
                throw new Exception("没指定要删除的图片！");
            for (int i = 0; i < PicIds.Length; i++)
            {
                KstCmsBase.DAL.Product.Product.ProductPic_delete(Convert.ToInt32(PicIds[i]));
            }
            RepMain_bind();

        }

        void Button1_Click(object sender, EventArgs e)
        {
            string SortNo = (KstCmsBase.DAL.Product.Product.GetProductPics(ProID).Count + 1).ToString();
            string UpPath = string.Empty;
            if (Read_Cache("productpic_path") != null)
                UpPath = Read_Cache("productpic_path").ToString();
            else
            {
                UpPath = SysRootUrl + "/" + KstCmsBase.Common.Fucs.GetConfigValue("productpic_path");
                Set_Cache("productpic_path", UpPath);
            }

            int Product_spicW = 0, Product_spicH = 0;
            int Product_mpicW = 0, Product_mpicH = 0;
            if (Read_Cache("Product_spicW") != null)
                Product_spicW = Convert.ToInt32(Read_Cache("Product_spicW"));
            else
            {
                Product_spicW = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("Product_spicW"));
                Set_Cache("Product_spicW", Product_spicW);
            }

            if (Read_Cache("Product_spicH") != null)
                Product_spicH = Convert.ToInt32(Read_Cache("Product_spicH").ToString());
            else
            {
                Product_spicH = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("Product_spicH"));
                Set_Cache("Product_spicH", Product_spicH);
            }

            if (Read_Cache("Product_mpicW") != null)
                Product_mpicW = Convert.ToInt32(Read_Cache("Product_mpicW").ToString());
            else
            {
                Product_mpicW = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("Product_mpicW"));
                Set_Cache("Product_mpicW", Product_mpicW);
            }

            if (Read_Cache("Product_mpicH") != null)
                Product_mpicH = Convert.ToInt32(Read_Cache("Product_mpicH").ToString());
            else
            {
                Product_mpicH = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("Product_mpicH"));
                Set_Cache("Product_mpicH", Product_mpicH);
            }

            KstCmsBase.Common.FStream FS = new KstCmsBase.Common.FStream();
            string Pic1 = FS.Set_SmallImg(txt_FilePath.Text.Trim(), UpPath + "/small/" + DateTime.Now.ToString("yyyy-MM-dd") + "/", Product_spicW, Product_spicH);
            string Pic2 = FS.Set_SmallImg(txt_FilePath.Text.Trim(), UpPath + "/medium/" + DateTime.Now.ToString("yyyy-MM-dd") + "/", Product_mpicW, Product_mpicH);
            string[] data = new string[]{
                ProID,
                txt_FileName.Text.Trim(),
                Pic1,
                Pic2,
                txt_FilePath.Text.Trim(),
                SortNo
            };
            KstCmsBase.DAL.Product.Product.ProductPic_Insert(data, "ProID", "PicName", "Pic1", "Pic2", "Pic3", "SortNo");
            RepMain_bind();

        }

        void RepMain_bind()
        {
            KstCmsBase.Collection.Product.ProductPicCollection FileItems = KstCmsBase.DAL.Product.Product.GetProductPics(ProID);
            AspNetPager1.RecordCount = FileItems.Count;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                FileItems.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize - 1);
            }
            else
            {
                FileItems.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.RecordCount);
            }
            PageInfo.Text = "<span style=\"color:red\">" + this.AspNetPager1.RecordCount.ToString() + "</span> ," + this.AspNetPager1.CurrentPageIndex.ToString() + "/" + this.AspNetPager1.PageCount.ToString();
            RepMain.DataSource = FileItems;
            RepMain.DataBind();

        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            RepMain_bind();

        }
    }
}