﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.products.protype
{
    public partial class Field2List : KstCmsBase.WebPage.ValidationPage
    {
        string TypeID = string.Empty;
        protected string CurrentUrl = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            CurrentUrl = Request.Url.PathAndQuery;
            TypeID = Request.QueryString.Get("TypeID");
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            Button1.Click += new EventHandler(Button1_Click);
            if (!IsPostBack)
            {
                repMain_Bind();
            }
        }

        void Button1_Click(object sender, EventArgs e)
        {
            int r = KstCmsBase.DAL.Product.ProductType.GetField2List(TypeID).Count + 1;
            string[] data = new string[]{
                TypeID,
                txt_FieldName.Text.Trim(),
                r.ToString()
            };
            KstCmsBase.DAL.Product.ProductType.Field2_Insert(data, "TypeID", "FieldName", "SortNo");
            repMain_Bind();
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            string FieldId = e.CommandName.ToString();
            int ExtId = Convert.ToInt32(e.CommandArgument.ToString());
            switch (ExtId)
            {
                case 0:
                    string FieldName = Request.Form["FieldName_" + FieldId];
                    string SortNo = Request.Form["SortNo_" + FieldId];
                    string[] data = new string[] { FieldName, SortNo };
                    KstCmsBase.DAL.Product.ProductType.Field2_Update(data, Convert.ToInt32(FieldId), "FieldName", "SortNo");
                    break;
                case 1:
                    KstCmsBase.DAL.Product.ProductType.Field2_Delete(FieldId);
                    break;
            }
            repMain_Bind();
        }

        void repMain_Bind()
        {
            RepMain.DataSource = KstCmsBase.DAL.Product.ProductType.GetField2List(TypeID);
            RepMain.DataBind();
        }
    }
}