﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.products.protype
{
    public partial class index : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            Button1.Click += new EventHandler(Button1_Click);
            if (!IsPostBack)
            {
                repMain_bind();
            }
        }

        void Button1_Click(object sender, EventArgs e)
        {
            string[] data = new string[] { txt_TypeName.Text.Trim() };
            KstCmsBase.DAL.Product.ProductType.ProductTypeInsert(data, "TypeName");
            repMain_bind();
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                KstCmsBase.Collection.Product.ProductField1Collection Field1s = ((KstCmsBase.Entities.Product.ProductType_Ent)e.Item.DataItem).Field1List;
                foreach (KstCmsBase.Entities.Product.Field1_Ent Field in Field1s)
                {
                    ((Literal)e.Item.FindControl("Literal1")).Text += Field.FieldName + ",";
                }
                KstCmsBase.Collection.Product.ProductField2Collection Field2s = ((KstCmsBase.Entities.Product.ProductType_Ent)e.Item.DataItem).Field2List;
                foreach (KstCmsBase.Entities.Product.Field2_Ent Field in Field2s)
                {
                    ((Literal)e.Item.FindControl("Literal2")).Text += Field.FieldName + ",";
                }
                int IsSys = ((KstCmsBase.Entities.Product.ProductType_Ent)e.Item.DataItem).IsSys;
                if (IsSys == 1)
                {
                    ((Button)e.Item.FindControl("btn2")).Enabled = false;

                }
            }
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            string TypeId=e.CommandName.ToString();
            string TypeName = Request.Form["TypeName_" + TypeId];
            switch (Convert.ToInt32(e.CommandArgument.ToString()))
            {
                case 0:
                    string[] data = new string[] { TypeName };
                    KstCmsBase.DAL.Product.ProductType.ProductTypeUpdate(data, Convert.ToInt32(TypeId), "TypeName");
                    break;
                case 1:
                    KstCmsBase.DAL.Product.ProductType.ProductTypeDelete(TypeId);
                    break;
            }
            repMain_bind();
        }

        void repMain_bind()
        {

            KstCmsBase.Collection.Product.ProductTypeCollection ProductType = KstCmsBase.DAL.Product.ProductType.GetProductTypeList();



            AspNetPager1.RecordCount = ProductType.Count;
            System.Collections.ArrayList items = null;
            if (AspNetPager1.RecordCount == 0)
                AspNetPager1.CurrentPageIndex = 0;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                items = ProductType.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
            }
            else
            {
                int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                items = ProductType.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
            }
            RepMain.DataSource = items;
            RepMain.DataBind();
        }


        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            repMain_bind();

        }
    }
}