﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.uPage
{
    public partial class uPageList :KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            if (!IsPostBack)
            {
                ShowSiteDrp();
            }
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowLm(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);

        }

        void ShowLm(string SiteId, string MenuId)
        {
            bool t = true;
            lit_Lmlink.Text = "";
            KstCmsBase.Collection.WebLmCollection WebLmItems = KstCmsBase.DAL.WebLM.Get_LMList(Convert.ToInt32(SiteId), Convert.ToInt32(MenuId), 1, "LmID", "LmName");
            for(int i=0;i<WebLmItems.Count;i++)
            {
                string lmid=((KstCmsBase.Entities.WebLm_ent)WebLmItems[i]).LmID.ToString();
                string lmname=((KstCmsBase.Entities.WebLm_ent)WebLmItems[i]).LmName;
                lit_Lmlink.Text += "<td width=\"80\" nowrap id=\"btn" + i + "\" onclick=\"ClickBtn(this," + WebLmItems.Count + ",'" + lmid + "');\" class=\"ActiveBtn1\" align=\"center\">" + lmname + "</td>";
                if (i == 0)
                {
                    t = false;
                    ScriptManager.RegisterStartupScript(this.UpdatePanel1, typeof(UpdatePanel), "", "ClickBtn(document.getElementById('btn" + i + "')," + WebLmItems.Count + ",'" + lmid + "');", true);
                }
            }
            if (t)
            {
                ScriptManager.RegisterStartupScript(this.UpdatePanel1, typeof(UpdatePanel), "", "parent.mainFrame.location.href = \"ShowTip.aspx\";", true);
            }
        }


        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            drp_SiteList.SelectedValue = DefaultSite.SiteID.ToString();
            ShowMenuDrp(drp_SiteList.SelectedValue);
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 0, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选择导航栏", "0"));
        }

    }
}