﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.wz.wzlb
{
    public partial class AddFrm : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                if (!string.IsNullOrEmpty(drp_SiteList.SelectedValue) && drp_SiteList.SelectedValue != "")
                {
                    ShowMenuDrp(drp_SiteList.SelectedValue);
                    ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
                    Set_Control();
                }
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string[] data = new string[]{
                drp_SiteList.SelectedValue,
                drp_MenuList.SelectedValue,
                txt_LbName.Text.Trim(),
                txt_SortNo.Text.Trim(),
                txt_MateKey.Text.Trim(),
                txt_MateDesc.Text.Trim(),
                txt_FileName.Text.Trim(),
                drp_TempList.SelectedValue
            };
            KstCmsBase.DAL.Wz.WzLB.Wzlb_Insert(data, "SiteID", "MenuID", "LbName", "SortNo", "MateKey", "MateDesc", "FileName", "TempID");
            ShowMsgModle("录入成功！","location.href='index.aspx'");
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            Set_Control();
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
            Set_Control();
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
            drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();
            drp_SiteList.Items.Insert(0, new ListItem("请选择所属站点", "0"));
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 2, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0,new ListItem("请选择所属导航", "0"));
        }

        void Set_Control()
        {
            string[] Cons = new string[] { "所属站点~!", "所属导航~!", "类别名称~!", "生成文件~noChinese!" };
            base.Set_Control(Cons, drp_SiteList, drp_MenuList, txt_LbName, txt_FileName);
            txt_SortNo.Attributes.Add("onkeydown", "IsDigit();");
            txt_SortNo.Text = (KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), "LbID").Count + 1).ToString();
        }
        void ShowDrpTempList(int SiteId)
        {
            drp_TempList.Items.Clear();
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.WzList, SiteId);
            foreach (KstCmsBase.Entities.Template_Ent Temp in TempItems)
            {
                ListItem item = new ListItem();
                item.Value = Temp.TempID.ToString();
                item.Text = Temp.TempName;
                if (Temp.DefaultAct == 1)
                    item.Selected = true;
                drp_TempList.Items.Add(item);
            }
            drp_TempList.Items.Insert(0, new ListItem("请选择模板", "0"));
        }
    }
}