﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.wz.wzlb
{
    public partial class index : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            btn_Sort.Click += new EventHandler(btn_Sort_Click);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                if (!string.IsNullOrEmpty(drp_SiteList.SelectedValue) && drp_SiteList.SelectedValue != "")
                {
                    ShowMenuDrp(drp_SiteList.SelectedValue);
                    RepMain_Bind(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
                }

            }
        }

        void btn_Sort_Click(object sender, EventArgs e)
        {
            string lbids = Request.Form.Get("chxbox");
            if (!string.IsNullOrEmpty(lbids))
            {
                string[] s = lbids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                for (int i = 0; i < s.Length; i++)
                {
                    string[] data = new string[] { Request.Form.Get("SortNo_" + s[i]) };
                    KstCmsBase.DAL.Wz.WzLB.Wzlb_Update(Convert.ToInt32(s[i]), data, "SortNo");
                }
            }
            RepMain_Bind(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            string lbid = e.CommandName.ToString();

            KstCmsBase.Entities.Wz.WzLB_Ent WZLB = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(Convert.ToInt32(lbid), "SiteID", "MenuID", "FileName");
            string UrlFile = GetSiteMenuUrl(WZLB.SiteID, WZLB.MenuID);
            string HtmlExt = KstCmsBase.Common.Fucs.GetConfigValue("htmlext");
            string[] strFiles = System.IO.Directory.GetFiles(Server.MapPath(UrlFile), WZLB.FileName + "*" + HtmlExt);
            foreach (string file in strFiles)
                System.IO.File.Delete(file);


            KstCmsBase.DAL.Wz.WzLB.Wzlb_Delete(Convert.ToInt32(lbid));
            RepMain_Bind(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
        }

        void RepMain_Bind(string SiteId,string MenuId)
        {
            RepMain.DataSource = KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(Convert.ToInt32(SiteId), Convert.ToInt32(MenuId), "LbID", "LbName", "SortNo");
            RepMain.DataBind();

        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            RepMain_Bind(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
            RepMain_Bind(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
        }


        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 2, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选导航", "0"));
            if (drp_MenuList.Items.Count > 1)
                drp_MenuList.SelectedIndex = 1;
        }



    }
}