﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Ad
{
    public partial class AddFrm : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                Set_Control();
                GetExeFileList();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string[] data = new string[]{
                txt_AdName.Text.Trim(),
                txt_PicH.Text.Trim(),
                txt_PicW.Text.Trim(),
                drp_ExeFile.SelectedValue
            };
            KstCmsBase.DAL.Ad.PicPlay.PicPlay_Insert(data, "AdName", "PicH", "PicW", "ExeFile");
            Response.Redirect("index.aspx");
        }

        void Set_Control()
        {
            string[] cons = new string[]{
                "播放名称~!",
                "图片宽度~int!",
                "图片高度~int!"
            };
            base.Set_Control(cons, txt_AdName, txt_PicW, txt_PicH);
            txt_PicH.Attributes.Add("onkeydown", "IsDigit();");
            txt_PicW.Attributes.Add("onkeydown", "IsDigit();");
        }

        void GetExeFileList()
        {
            string PathUrl = SysRootUrl + "/Scripts/PicPlay";
            string[] strFiles = System.IO.Directory.GetFiles(Server.MapPath(PathUrl), "*.aspx");
            foreach (string file in strFiles)
            {
                string MyFile = file.Substring(file.LastIndexOf("\\") + 1);
                ListItem item = new ListItem();
                item.Value = MyFile;
                item.Text = MyFile;
                drp_ExeFile.Items.Add(item);
            }
            drp_ExeFile.Items.Insert(0, new ListItem("请选择播放样式文件", "0"));
        }
    }
}