﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Ad
{
    public partial class EditFrm : KstCmsBase.WebPage.FrmControl
    {
        string Adid = System.Web.HttpContext.Current.Request.QueryString.Get("Adid");
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                GetPicPlayinfo();
               
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string[] data = new string[]{
                txt_AdName.Text.Trim(),
                txt_PicH.Text.Trim(),
                txt_PicW.Text.Trim(),
                drp_ExeFile.SelectedValue
            };
            KstCmsBase.DAL.Ad.PicPlay.PicPlay_Update(Convert.ToInt32(Adid), data, "AdName", "PicH", "PicW", "ExeFile");
            Response.Redirect("index.aspx");
        }

        void GetPicPlayinfo()
        {
            KstCmsBase.Entities.Ad.PicPlay_Ent PicPlay = KstCmsBase.DAL.Ad.PicPlay.Get_PicPlayInfo(Convert.ToInt32(Adid));
            txt_AdName.Text = PicPlay.AdName;
            txt_PicH.Text = PicPlay.PicH.ToString();
            txt_PicW.Text = PicPlay.PicW.ToString();
            GetExeFileList();
            drp_ExeFile.SelectedValue = PicPlay.ExeFile;
            Set_Control();
        }

        void Set_Control()
        {
            string[] cons = new string[]{
                "播放名称~!",
                "图片宽度~int!",
                "图片高度~int!"
            };
            base.Set_Control(cons, txt_AdName, txt_PicW, txt_PicH);
            txt_PicH.Attributes.Add("onkeydown", "IsDigit();");
            txt_PicW.Attributes.Add("onkeydown", "IsDigit();");
        }

        void GetExeFileList()
        {
            string PathUrl = SysRootUrl + "/Scripts/PicPlay";
            string[] strFiles = System.IO.Directory.GetFiles(Server.MapPath(PathUrl), "*.aspx");
            foreach (string file in strFiles)
            {
                string MyFile = file.Substring(file.LastIndexOf("\\") + 1);
                ListItem item = new ListItem();
                item.Value = MyFile;
                item.Text = MyFile;
                drp_ExeFile.Items.Add(item);
            }
            drp_ExeFile.Items.Insert(0, new ListItem("请选择播放样式文件", "0"));
        }
    }
}