﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Ad
{
    public partial class PicList : KstCmsBase.WebPage.FrmControl
    {
        string Adid = System.Web.HttpContext.Current.Request.QueryString.Get("Adid");
        protected void Page_Load(object sender, EventArgs e)
        {
            Okbtn.Click += new EventHandler(Okbtn_Click);
            btn_Sort.Click += new EventHandler(btn_Sort_Click);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            if (!IsPostBack)
            {
                Set_Control();
                RepMain_Bind();
            }
        }

        void btn_Sort_Click(object sender, EventArgs e)
        {
            string picids = Request.Form.Get("chxbox");
            string[] ids = picids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            foreach (string id in ids)
            {
                string adtitle = Request.Form.Get("txt_AdTitle_" + id);
                string sortno = Request.Form.Get("txt_SortNo_" + id);
                string[] data = new string[] { adtitle, sortno };
                KstCmsBase.DAL.Ad.PicPlay.Pic_Update(Convert.ToInt32(id), data, "AdTitle", "SortNo");
            }
            RepMain_Bind();
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int act = Convert.ToInt32(e.CommandArgument.ToString());
            int picid = Convert.ToInt32(e.CommandName.ToString());
            switch (act)
            {
                case 0:
                    KstCmsBase.DAL.Ad.PicPlay.PicPlayList_Delete(picid);
                    break;
            }
            RepMain_Bind();
        }

        void Okbtn_Click(object sender, EventArgs e)
        {
            if (KstCmsBase.DAL.Ad.PicPlay.Get_PicPlay_PicList(Convert.ToInt32(Adid)).Count >= 6)
                throw new Exception("图片播放最多6张图片,不能增加了！");
            string PicPath = txt_PicPath.Text.Trim();

            string[] data = new string[]{
                txt_adtitle.Text.Trim(),PicPath,txt_LinkUrl.Text.Trim(),txt_SortNo.Text.Trim(),Adid};
            KstCmsBase.DAL.Ad.PicPlay.Pic_Insert(data, "AdTitle", "PicPath", "LinkUrl", "SortNo", "AdID");
            RepMain_Bind();
        }

        void RepMain_Bind()
        {
            KstCmsBase.Collection.Ad.PicCollection PicItems = KstCmsBase.DAL.Ad.PicPlay.Get_PicPlay_PicList(Convert.ToInt32(Adid));
            RepMain.DataSource = PicItems;
            RepMain.DataBind();
        }

        void Set_Control()
        {
            string[] cons = new string[] { "标题名称~!","上传图片~!", "排序~int!" };
            base.Set_Control(cons, txt_adtitle,txt_PicPath, txt_SortNo);
            txt_SortNo.Attributes.Add("onkeydown", "IsDigit();");
            Literal1.Text = KstCmsBase.DAL.Ad.PicPlay.Get_PicPlayInfo(Convert.ToInt32(Adid)).AdName;
            txt_PicPath.Enabled = false;
        }
    }
}