﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Site
{
    public partial class AddSite : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                Set_Control();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            KstCMS.BLL.SiteBLL.WebSite BLL = new KstCMS.BLL.SiteBLL.WebSite();
            
            int IsDefault = chx_Default.Checked ? 1 : 0;
            int IsAct = chx_Act.Checked ? 1 : 0;
            string[] data = new string[]{
                txt_SiteVer.Text.Trim().ToLower(),
                txt_VerName.Text.Trim(),
                txt_SiteName.Text.Trim(),
                txt_SiteTitle.Text.Trim(),
                txt_MateKey.Text.Trim(),
                txt_MateDesc.Text.Trim(),
                Request.Form.Get("txt_CopyRight"),
                IsDefault.ToString(),
                txt_SortNo.Text.Trim(),
                IsAct.ToString(),
                drp_TempList.SelectedValue
            };
            BLL.Add(data, "SiteVer", "VerName", "SiteName", "SiteTitle", "MateKey", "MateDesc", "CopyRight", "DefaultSite", "SortNO", "SiteACT", "TempID");
            ShowMsgModle("增加成功！", "parent.document.location.reload();");
            KstCmsBase.Common.Fucs.CreateDir(Server.MapPath("~/" + txt_SiteVer.Text.Trim().ToLower()));
        }

        void ShowDrpTempList()
        {
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.HomePage);
            foreach (KstCmsBase.Entities.Template_Ent Temp in TempItems)
            {
                ListItem item = new ListItem();
                item.Value = Temp.TempID.ToString();
                item.Text = Temp.TempName;
                drp_TempList.Items.Add(item);
            }
            drp_TempList.Items.Insert(0, new ListItem("请选择模板", "0"));

        }


        void Set_Control()
        {
            ShowDrpTempList();
            string[] Cons = new string[] { "网站版本~noChinese!", "版本别名~!", "网站名称~!", "网站标题~!", "Meta关键字~!", "Meta注解~!", "排序~int!"};
            base.Set_Control(Cons, txt_SiteVer, txt_VerName, txt_SiteName, txt_SiteTitle, txt_MateKey, txt_MateDesc, txt_SortNo);
            int r = KstCmsBase.DAL.WebSite.Get_WebSiteList("SiteID").Count + 1;
            txt_SortNo.Text = r.ToString();
        }

    }
}